unit Utilitaires;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses Windows, SysUtils, Classes;

const
  LangueRef= 'Franais'; // Langue de reference
  ExtLangue= '.lng';     // Extension des fichiers de langue
  ExtAide= '.hlp';       // Extension des fichiers d'aide
  NumMenuLangue= 3;      // Numero du menu contenant les langues
  NumItemLangue= 0;      // Numero de la ligne des langues dans le menu

var
  RepAppli: string; // Repertoire ou se trouve l'application
  NomGenerique: string; // Nom generique pour fichier -> nouveau

  function EpureTexte(LeTexte: string): string;
  procedure ParseLigne(LaLigne: string;var Numero: longint; var Texte: string);

implementation

function EpureTexte(LeTexte: string): string;
{ Elimine les & de soulignement du raccourci }
var
  Position: integer;
begin
  Position:= pos('&',LeTexte);
  if Position<>0 then System.delete(LeTexte,Position,1);
  Result:= LeTexte;
end;

procedure ParseLigne(LaLigne: string;var Numero: longint; var Texte: string);
{ Decoupe une ligne Numero#Texte en 2 entite Numero et Texte }
var
  N: integer;
begin
  N:= pos('#',LaLigne);
  if N<>0 then
  begin
    Numero:= StrToInt(copy(LaLigne,1,N-1));
    delete(LaLigne,1,N);
    Texte:= LaLigne;
  end
  else
  begin
    Numero:= 0;
    Texte:= '';
  end;
end;

end.
