unit MiseEnPage;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ToolWin, ImgList, ActnList, ExtCtrls,
  SynEditPrintTypes, SynEditPrint;

type
  TFrmMiseEnPage = class(TForm)
    PCtrlMiseEnPage: TPageControl;
    BtnOk: TButton;
    BtnAnnule: TButton;
    TShMarges: TTabSheet;
    TShOptions: TTabSheet;
    TShEnTetePiedDePage: TTabSheet;
    LUnite: TLabel;
    LHaut: TLabel;
    LBas: TLabel;
    LGauche: TLabel;
    LDroite: TLabel;
    LReliure: TLabel;
    CBUnite: TComboBox;
    EdtHaut: TEdit;
    EdtBas: TEdit;
    EdtGauche: TEdit;
    EdtDroite: TEdit;
    EdtReliure: TEdit;
    GBEntetePiedDePage: TGroupBox;
    EdtEntete: TEdit;
    EdtPiedDePage: TEdit;
    LEntete: TLabel;
    LPiedDePage: TLabel;
    IlBarreOutils: TImageList;
    BarreOutils: TToolBar;
    TBtnNumPage: TToolButton;
    TBtnNbPages: TToolButton;
    ToolButton3: TToolButton;
    TBtnDate: TToolButton;
    TBtnHeure: TToolButton;
    ToolButton6: TToolButton;
    TBtnTitre: TToolButton;
    ToolButton8: TToolButton;
    TBtnFont: TToolButton;
    ToolButton10: TToolButton;
    TBtnGras: TToolButton;
    TBtnItalique: TToolButton;
    TBtnSouligne: TToolButton;
    TBtnDateHeure: TToolButton;
    GBEntete: TGroupBox;
    REdtGaucheEntete: TRichEdit;
    REdtCentreEntete: TRichEdit;
    REdtDroiteEntete: TRichEdit;
    LGaucheEntete: TLabel;
    LCentreEntete: TLabel;
    LDroiteEntete: TLabel;
    ChBLigneEntete: TCheckBox;
    ChBEncadreEntete: TCheckBox;
    ChBOmbreEntete: TCheckBox;
    GBPiedDePage: TGroupBox;
    LGauchePiedDePage: TLabel;
    LCentrePiedDePage: TLabel;
    LDroitePiedDePage: TLabel;
    REdtGauchePiedDePage: TRichEdit;
    REdtCentrePiedDePage: TRichEdit;
    REdtDroitePiedDePage: TRichEdit;
    ChBLignePiedDePage: TCheckBox;
    ChBEncadrePiedDePage: TCheckBox;
    ChBOmbrePiedDePage: TCheckBox;
    ALstMiseEnPage: TActionList;
    ActNumPage: TAction;
    ActNbPages: TAction;
    ActDate: TAction;
    ActHeure: TAction;
    ActDateHeure: TAction;
    ActTitre: TAction;
    ActFont: TAction;
    ActGras: TAction;
    ActItalique: TAction;
    ActSouligne: TAction;
    ChBNumerosDeLigne: TCheckBox;
    ChBNumeroDansMarge: TCheckBox;
    ChBSyntaxe: TCheckBox;
    ChBRetourALaLigne: TCheckBox;
    ImgPage: TImage;
    DlgFont: TFontDialog;
    procedure FormShow(Sender: TObject);
    procedure EdtHautEnter(Sender: TObject);
    procedure EdtHautExit(Sender: TObject);
    procedure EdtHautKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EdtHautKeyPress(Sender: TObject; var Key: Char);
    procedure ChBNumerosDeLigneClick(Sender: TObject);
    procedure REdtGaucheEnteteEnter(Sender: TObject);
    procedure REdtGaucheEnteteSelectionChange(Sender: TObject);
    procedure ChBLigneEnteteEnter(Sender: TObject);
    procedure ActNumPageExecute(Sender: TObject);
    procedure ActNbPagesExecute(Sender: TObject);
    procedure ActDateExecute(Sender: TObject);
    procedure ActHeureExecute(Sender: TObject);
    procedure ActDateHeureExecute(Sender: TObject);
    procedure ActTitreExecute(Sender: TObject);
    procedure ActFontExecute(Sender: TObject);
    procedure ActGrasExecute(Sender: TObject);
    procedure ActItaliqueExecute(Sender: TObject);
    procedure ActSouligneExecute(Sender: TObject);
  private
    { Dclarations prives }
    Editor: TRichEdit;
    function CurrText: TTextAttributes;
    procedure ValideBarreOutils;
    // Dessin des marges
    procedure FlecheBas(X, Y: longint;Efface: boolean);
    procedure FlecheHaut(X, Y: longint;Efface: boolean);
    procedure FlecheDroite(X, Y: longint;Efface: boolean);
    procedure FlecheGauche(X, Y: longint;Efface: boolean);
  public
    { Dclarations publiques }
    procedure GetValeurs(SynEditPrint: TSynEditPrint);
    procedure SetValeurs(SynEditPrint: TSynEditPrint);
    function Execute(Titre: string): boolean;
  end;

var
  FrmMiseEnPage: TFrmMiseEnPage;

implementation

{$R *.DFM}

uses Alertes;

{*****************************************************************************}
{ Actions                                                                     }
{*****************************************************************************}

procedure TFrmMiseEnPage.ActNumPageExecute(Sender: TObject);
begin
  Editor.SelText:= '$PAGENUM$';
end;

procedure TFrmMiseEnPage.ActNbPagesExecute(Sender: TObject);
begin
  Editor.SelText:= '$PAGECOUNT$';
end;

procedure TFrmMiseEnPage.ActDateExecute(Sender: TObject);
begin
  Editor.SelText:= '$DATE$';
end;

procedure TFrmMiseEnPage.ActHeureExecute(Sender: TObject);
begin
  Editor.SelText:= '$TIME$';
end;

procedure TFrmMiseEnPage.ActDateHeureExecute(Sender: TObject);
begin
  Editor.SelText:= '$DATETIME$';
end;

procedure TFrmMiseEnPage.ActTitreExecute(Sender: TObject);
begin
  Editor.SelText:= '$TITLE$';
end;

procedure TFrmMiseEnPage.ActFontExecute(Sender: TObject);
begin
  DlgFont.Font.Assign(CurrText);
  if DlgFont.Execute then CurrText.Assign(DlgFont.Font);
end;

procedure TFrmMiseEnPage.ActGrasExecute(Sender: TObject);
begin
  if TBtnGras.Down then
    CurrText.Style := CurrText.Style + [fsBold]
  else
    CurrText.Style := CurrText.Style - [fsBold];
end;

procedure TFrmMiseEnPage.ActItaliqueExecute(Sender: TObject);
begin
  if TBtnItalique.Down then
    CurrText.Style := CurrText.Style + [fsItalic]
  else
    CurrText.Style := CurrText.Style - [fsItalic];
end;

procedure TFrmMiseEnPage.ActSouligneExecute(Sender: TObject);
begin
  if TBtnSouligne.Down then
    CurrText.Style := CurrText.Style + [fsUnderline]
  else
    CurrText.Style := CurrText.Style - [fsUnderline];
end;

{*****************************************************************************}
{ Fonctions de la fiche                                                       }
{*****************************************************************************}

procedure TFrmMiseEnPage.FormShow(Sender: TObject);
begin
  PCtrlMiseEnPage.ActivePage:= TShMarges;
  ChBNumeroDansMarge.Enabled:= ChBNumerosDeLigne.Checked;
  Editor:= REdtGaucheEntete;
  ValideBarreOutils;
end;

procedure TFrmMiseEnPage.EdtHautEnter(Sender: TObject);
begin
  with Sender as TEdit do
  begin
    case Tag of
      1: begin
           FlecheBas(121,16,false);
           FlecheHaut(121,32,false);
         end;
      2: begin
           FlecheBas(121,101,false);
           FlecheHaut(121,120,false);
         end;
      3: begin
           FlecheDroite(35,133,false);
           FlecheGauche(46,133,false);
         end;
      4: begin
           FlecheDroite(96,133,false);
           FlecheGauche(107,133,false);
         end;
      5: begin
           FlecheDroite(31,133,false);
           FlecheGauche(35,133,false);
         end;
      6: begin
           FlecheBas(121,16,false);
           FlecheHaut(121,21,false);
         end;
      7: begin
           FlecheBas(121,110,false);
           FlecheHaut(121,120,false);
         end;
    end;
  end;
end;

procedure TFrmMiseEnPage.EdtHautExit(Sender: TObject);
begin
  with Sender as TEdit do
  try
    StrToFloat(Text);
    case Tag of
      1: begin
           FlecheBas(121,16,true);
           FlecheHaut(121,32,true);
         end;
      2: begin
           FlecheBas(121,101,true);
           FlecheHaut(121,120,true);
         end;
      3: begin
           FlecheDroite(35,133,true);
           FlecheGauche(46,133,true);
         end;
      4: begin
           FlecheDroite(96,133,true);
           FlecheGauche(107,133,true);
         end;
      5: begin
           FlecheDroite(31,133,true);
           FlecheGauche(35,133,true);
         end;
      6: begin
           FlecheBas(121,16,true);
           FlecheHaut(121,21,true);
         end;
      7: begin
           FlecheBas(121,110,true);
           FlecheHaut(121,120,true);
         end;
    end;
  except
    BoiteMessage(1,Text,'');
    SetFocus;
  end;
end;

procedure TFrmMiseEnPage.EdtHautKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ActiveControl is TEdit then
    if Key=VK_RETURN then perform(WM_NEXTDLGCTL,0,0);
end;

procedure TFrmMiseEnPage.EdtHautKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then Key:=chr(0);
end;

procedure TFrmMiseEnPage.ChBNumerosDeLigneClick(Sender: TObject);
begin
  ChBNumeroDansMarge.Enabled:= ChBNumerosDeLigne.Checked;
end;

procedure TFrmMiseEnPage.REdtGaucheEnteteEnter(Sender: TObject);
begin
  Editor:= Sender as TRichEdit;
  ValideBarreOutils;
  if Editor.Lines.Text<>'' then
  begin
    TBtnGras.Down:= fsBold in CurrText.Style;
    TBtnItalique.Down:= fsItalic in CurrText.Style;
    TBtnSouligne.Down:= fsUnderline in CurrText.Style;
  end
  else
  begin
    TBtnGras.Down:= false;
    TBtnItalique.Down:= false;
    TBtnSouligne.Down:= false;
  end;
end;

procedure TFrmMiseEnPage.REdtGaucheEnteteSelectionChange(Sender: TObject);
begin
  TBtnGras.Down:= fsBold in CurrText.Style;
  TBtnItalique.Down:= fsItalic in CurrText.Style;
  TBtnSouligne.Down:= fsUnderline in CurrText.Style;
end;

procedure TFrmMiseEnPage.ChBLigneEnteteEnter(Sender: TObject);
begin
  ValideBarreOutils;
end;

{*****************************************************************************}
{ Fonctions privee                                                            }
{*****************************************************************************}

function TFrmMiseEnPage.CurrText: TTextAttributes;
begin
  Result:= Editor.SelAttributes;
end;

procedure TFrmMiseEnPage.ValideBarreOutils;
begin
  ActNumPage.Enabled:= Editor.Focused;
  ActNbPages.Enabled:= Editor.Focused;
  ActDate.Enabled:= Editor.Focused;
  ActHeure.Enabled:= Editor.Focused;
  ActDateHeure.Enabled:= Editor.Focused;
  ActTitre.Enabled:= Editor.Focused;
  ActFont.Enabled:= Editor.Focused;
  ActGras.Enabled:= Editor.Focused;
  ActItalique.Enabled:= Editor.Focused;
  ActSouligne.Enabled:= Editor.Focused;
end;

// Dessin des marges

procedure TFrmMiseEnPage.FlecheBas(X, Y: Integer; Efface: boolean);
begin
  with ImgPage.Canvas do
  begin
    Pen.Style:= psSolid;
    Pen.Width:= 1;
    Pen.Mode:= pmCopy;
    if Efface then Pen.Color:= clWhite
              else Pen.Color:= clRed;
    // Ligne horizontale
    MoveTo(X-4,Y);
    LineTo(X+5,Y);
    // Ligne verticale
    MoveTo(X,Y);
    LineTo(X,Y-15);
    // Fleche
    MoveTo(X,Y-1);
    LineTo(X-3,Y-6);
    MoveTo(X,Y-1);
    LineTo(X+3,Y-6);
  end;
end;

procedure TFrmMiseEnPage.FlecheHaut(X, Y: Integer; Efface: boolean);
begin
  with ImgPage.Canvas do
  begin
    Pen.Style:= psSolid;
    Pen.Width:= 1;
    Pen.Mode:= pmCopy;
    if Efface then Pen.Color:= clWhite
              else Pen.Color:= clRed;
    // Ligne horizontale
    MoveTo(X-4,Y);
    LineTo(X+5,Y);
    // Ligne verticale
    MoveTo(X,Y);
    LineTo(X,Y+15);
    // Fleche
    MoveTo(X,Y+1);
    LineTo(X-3,Y+6);
    MoveTo(X,Y+1);
    LineTo(X+3,Y+6);
  end;
end;

procedure TFrmMiseEnPage.FlecheDroite(X, Y: Integer; Efface: boolean);
begin
  with ImgPage.Canvas do
  begin
    Pen.Style:= psSolid;
    Pen.Width:= 1;
    Pen.Mode:= pmCopy;
    if Efface then Pen.Color:= clWhite
              else Pen.Color:= clRed;
    // Ligne verticale
    MoveTo(X,Y-4);
    LineTo(X,Y+5);
    // Ligne horizontale
    MoveTo(X,Y);
    LineTo(X-15,Y);
    // Fleche
    MoveTo(X-1,Y);
    LineTo(X-6,Y-3);
    MoveTo(X-1,Y);
    LineTo(X-6,Y+3);
  end;
end;

procedure TFrmMiseEnPage.FlecheGauche(X, Y: Integer; Efface: boolean);
begin
  with ImgPage.Canvas do
  begin
    Pen.Style:= psSolid;
    Pen.Width:= 1;
    Pen.Mode:= pmCopy;
    if Efface then Pen.Color:= clWhite
              else Pen.Color:= clRed;
    // Ligne verticale
    MoveTo(X,Y-4);
    LineTo(X,Y+5);
    // Ligne horizontale
    MoveTo(X,Y);
    LineTo(X+15,Y);
    // Fleche
    MoveTo(X+1,Y);
    LineTo(X+6,Y-3);
    MoveTo(X+1,Y);
    LineTo(X+6,Y+3);
  end;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFrmMiseEnPage.GetValeurs(SynEditPrint: TSynEditPrint);
var
  N: longint;
begin
  with SynEditPrint do
  begin
    // Marges
    with Margins do
    begin
      UnitSystem:= TUnitSystem(CBUnite.ItemIndex);
      Left:= StrToFloat(EdtGauche.Text);
      Right:= StrToFloat(EdtDroite.Text);
      Top:= StrToFloat(EdtHaut.Text);
      Bottom:= StrToFloat(EdtBas.Text);
      Gutter:= StrToFloat(EdtReliure.Text);
      Header:= StrToFloat(EdtEntete.Text);
      Footer:= StrToFloat(EdtPiedDePage.Text);
    end;
    // Options
    LineNumbers:= ChBNumerosDeLigne.Checked;
    LineNumbersInMargin:= ChBNumeroDansMarge.Checked;
    Highlight:= ChBSyntaxe.Checked;
    Wrap:= ChBRetourALaLigne.Checked;
    // Entete
    with Header do
    begin
      Clear;
      for N:= 0 to REdtGaucheEntete.Lines.Count-1 do
        Add(REdtGaucheEntete.Lines[N],REdtGaucheEntete.Font,taLeftJustify,N+1);
      for N:= 0 to REdtCentreEntete.Lines.Count-1 do
        Add(REdtCentreEntete.Lines[N],REdtCentreEntete.Font,taCenter,N+1);
      for N:= 0 to REdtDroiteEntete.Lines.Count-1 do
        Add(REdtDroiteEntete.Lines[N],REdtDroiteEntete.Font,taRightJustify,N+1);
      FrameTypes:= [];
      if ChBLigneEntete.Checked then FrameTypes:= FrameTypes + [ftLine];
      if ChBEncadreEntete.Checked then FrameTypes:= FrameTypes + [ftBox];
      if ChBOmbreEntete.Checked then FrameTypes:= FrameTypes + [ftShaded];
    end;
    // Pied de page
    with Footer do
    begin
      Clear;
      for N:= 0 to REdtGauchePiedDePage.Lines.Count-1 do
        Add(REdtGauchePiedDePage.Lines[N],REdtGauchePiedDePage.Font,taLeftJustify,N+1);
      for N:= 0 to REdtCentrePiedDePage.Lines.Count-1 do
        Add(REdtCentrePiedDePage.Lines[N],REdtCentrePiedDePage.Font,taCenter,N+1);
      for N:= 0 to REdtDroitePiedDePage.Lines.Count-1 do
        Add(REdtDroitePiedDePage.Lines[N],REdtDroitePiedDePage.Font,taRightJustify,N+1);
      FrameTypes:= [];
      if ChBLignePiedDePage.Checked then FrameTypes:= FrameTypes + [ftLine];
      if ChBEncadrePiedDePage.Checked then FrameTypes:= FrameTypes + [ftBox];
      if ChBOmbrePiedDePage.Checked then FrameTypes:= FrameTypes + [ftShaded];
    end;
  end;
end;

procedure TFrmMiseEnPage.SetValeurs(SynEditPrint: TSynEditPrint);
begin
  with SynEditPrint do
  begin
    // Marges
    with Margins do
    begin
      CBUnite.ItemIndex:= ord(UnitSystem);
      EdtGauche.Text:= FloatToStr(Left);
      EdtDroite.Text:= FloatToStr(Right);
      EdtHaut.Text:= FloatToStr(Top);
      EdtBas.Text:= FloatToStr(Bottom);
      EdtReliure.Text:= FloatToStr(Gutter);
      EdtEntete.Text:= FloatToStr(Header);
      EdtPiedDePage.Text:= FloatToStr(Footer);
    end;
    // Options
    ChBNumerosDeLigne.Checked:= LineNumbers;
    ChBNumeroDansMarge.Checked:= LineNumbersInMargin;
    ChBSyntaxe.Checked:= Highlight;
    ChBRetourALaLigne.Checked:= Wrap;
    // Entete
    with Header do
    begin
      ChBLigneEntete.Checked:= ftLine in FrameTypes;
      ChBEncadreEntete.Checked:= ftBox in FrameTypes;
      ChBOmbreEntete.Checked:= ftShaded in FrameTypes;
    end;
    // Pied de page
    with Footer do
    begin
      ChBLignePiedDePage.Checked:= ftLine in FrameTypes;
      ChBEncadrePiedDePage.Checked:= ftBox in FrameTypes;
      ChBOmbrePiedDePage.Checked:= ftShaded in FrameTypes;
    end;
  end;
end;

function TFrmMiseEnPage.Execute(Titre: string): boolean;
begin
  Caption:= Titre;
  if ShowModal= mrOk then
  begin
    result:= true;
  end
  else result:= false;
end;

end.
