unit Main;

/////////////////////////////////////////////////////////////
//                                                         //
//                     SEdit                               //
// Editeur multi fichiers avec mise en evidence syntaxique //
//         Copyright (C) 2000 Alain JAFFRE                 //
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
//                Update history                           //
//                                                         //
//  V0.1.0  Premiere version                               //
//  V0.2.0  Les fonctions principales sont implementees    //
//  V0.2.1  Ajout:                                         //
//            Gestion des parametres de la ligne de        //
//             commande et du drag and drop                //
//            Message recherche non trouvee                //
//            Mise a jour de la mise en evidence de la     //
//             syntaxe apres enregistrement si l'extension //
//             a change                                    //
//            Aller a la ligne numero xxxx dans le menu    //
//             chercher                                    //
//            Enregistrement au format Unix                //
//            Gestion interne de la liste des fenetres     //
//  V0.2.2  Correction:                                    //
//            L'ouverture d'un fichier via la ligne de cde //
//              ne deverrouillait pas l'impression ...     //
//            Meme oublie sur les fichiers laches en drag  //
//              & drop                                     //
//          Amelioration:                                  //
//            Boite de liste des fenetres avec une         //
//              string grid pour gerer les ascenceurs      //
//  V0.2.3  Ajouts:                                        //
//            Affichage du language reconnu dans la barre  //
//              d'etat                                     //
//          Correction:                                    //
//            Posibilite d'utiliser TAB dans l'editeur     //
//            Les fichiers *.txt ne sont plus associs     //
//              a la mise en evidence de la syntaxe        //
//              Galaxy                                     //
//            Prise du focus apres un lache de fichier     //
//              sur SEdit                                  //
//  V0.2.4  Ajouts:                                        //
//            Mise en evidence de la syntaxe XML           //
//  V0.2.5 Corrections:                                    //
//            Mise en avant de SEDIT lorsque l'on lache    //
//              un fichiers dessus                         //
//  V0.2.6 Ajouts:                                         //
//            Choix de la mise en evidence                 //
//            Formats DOS (CR LF <-> #13#10),              //
//             Unix (LF <-> #10) et Mac (CR <-> #13)       //
//             selectionnable pour l'enregistrement        //
/////////////////////////////////////////////////////////////
//              Autre composants utiliss                  //
//              Other components used                      //
//                                                         //
//  SynEdit:                                               //
//    http://SynEdit.SourceForge.net                       //
//                                                         //
/////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, ToolWin, ActnList, StdActns, AppEvnts, ShellApi,
  StdCtrls;

type
  TFrmPrincipale = class(TForm)
    MenuPrincipal: TMainMenu;
    Fichier: TMenuItem;
    Edition: TMenuItem;
    Fenetre: TMenuItem;
    Aide: TMenuItem;
    Outils: TMenuItem;
    TBPrincipale: TToolBar;
    TBtnNouveau: TToolButton;
    TBtnOuvrir: TToolButton;
    TBtnSauver: TToolButton;
    ToolButton1: TToolButton;
    TBtnToutSauver: TToolButton;
    ToolButton2: TToolButton;
    TBtnCouper: TToolButton;
    TBtnCopier: TToolButton;
    TBtnColler: TToolButton;
    TBtnSupprimer: TToolButton;
    ToolButton3: TToolButton;
    TBtnDefaire: TToolButton;
    TBtnRefaire: TToolButton;
    ToolButton4: TToolButton;
    TBtnApercu: TToolButton;
    TBtnImprimer: TToolButton;
    ToolButton5: TToolButton;
    TBtnCascade: TToolButton;
    TBtnMosaiqueHorizontale: TToolButton;
    TBtnMosaiqueVerticale: TToolButton;
    ALPrincipale: TActionList;
    Chercher: TMenuItem;
    ActFichierNouveau: TAction;
    ActFichierOuvrir: TAction;
    ActFichierReouvrir: TAction;
    ActFichierEnregistrer: TAction;
    ActFichierEnregistrerSous: TAction;
    ActFichierToutEnregistrer: TAction;
    ActFichierMiseEnPage: TAction;
    ActFichierApercu: TAction;
    ActFichierImprimer: TAction;
    ActFichierFermer: TAction;
    ActFichierToutFermer: TAction;
    ActFichierQuitter: TAction;
    ActEditionDefaire: TAction;
    ActEditionRefaire: TAction;
    ActEditionCouper: TEditCut;
    ActEditionCopier: TEditCopy;
    ActEditionColler: TEditPaste;
    ActEditionSupprimer: TEditDelete;
    ActEditionToutSelectionner: TEditSelectAll;
    ActChercherRechercher: TAction;
    ActChercherDansFichier: TAction;
    ActChercherRemplacer: TAction;
    ActChercherSuivant: TAction;
    ActChercherPrecedent: TAction;
    ActOutilsPreferences: TAction;
    ActFenetreCascade: TWindowCascade;
    ActFenetreMosaiqueHorizontale: TWindowTileHorizontal;
    ActFenetreMosaiqueVerticale: TWindowTileVertical;
    ActFenetreToutReduire: TWindowMinimizeAll;
    ActFenetreToutReorganiser: TWindowArrange;
    ActAideRubrique: TAction;
    ActAideIndex: TAction;
    ActAideRecherche: TAction;
    ActAideAPropos: TAction;
    ActUpdateBarreEtat: TAction;
    Nouveau: TMenuItem;
    N1: TMenuItem;
    Ouvrir: TMenuItem;
    Reouvrir: TMenuItem;
    N2: TMenuItem;
    Enregistrer: TMenuItem;
    Enregistrersous: TMenuItem;
    Toutenregistrer: TMenuItem;
    N3: TMenuItem;
    Apercuavantimpression: TMenuItem;
    Imprimer: TMenuItem;
    N4: TMenuItem;
    Fermer: TMenuItem;
    Toutfermer: TMenuItem;
    N5: TMenuItem;
    Quitter: TMenuItem;
    Defaire: TMenuItem;
    Refaire: TMenuItem;
    N7: TMenuItem;
    Couper: TMenuItem;
    Copier: TMenuItem;
    Coller: TMenuItem;
    Supprimer: TMenuItem;
    Toutselectionner: TMenuItem;
    Rechercher: TMenuItem;
    Chercherdanslesfichiers: TMenuItem;
    Remplacer: TMenuItem;
    Occurancesuivante: TMenuItem;
    Occuranceprecedente: TMenuItem;
    Langues: TMenuItem;
    Francais: TMenuItem;
    Preferences: TMenuItem;
    Cascade: TMenuItem;
    Mosaquehorizontale: TMenuItem;
    Mosaqueverticale: TMenuItem;
    Toutreduire: TMenuItem;
    Toutreorganiser: TMenuItem;
    Rubriquedaide: TMenuItem;
    Recherche: TMenuItem;
    N6: TMenuItem;
    Apropos: TMenuItem;
    Recherchedanslaide1: TMenuItem;
    BarreEtat: TStatusBar;
    Miseenpage: TMenuItem;
    Fichier0: TMenuItem;
    Fichier1: TMenuItem;
    Fichier2: TMenuItem;
    Fichier3: TMenuItem;
    Fichier4: TMenuItem;
    Fichier5: TMenuItem;
    Fichier6: TMenuItem;
    Fichier7: TMenuItem;
    Fichier8: TMenuItem;
    Fichier9: TMenuItem;
    ApplicationEvents: TApplicationEvents;
    N8: TMenuItem;
    AllerALaLigne: TMenuItem;
    ActAllerALaLigne: TAction;
    ActFichierEnregistrerFormat: TAction;
    ActFichierEnregistrerSousFormat: TAction;
    Enregistrerauformat: TMenuItem;
    Enregistrersousauformat: TMenuItem;
    N9: TMenuItem;
    ActFenetreAutres: TAction;
    PlusDeFenetres: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    Fenetre0: TMenuItem;
    Fenetre1: TMenuItem;
    Fenetre2: TMenuItem;
    Fenetre3: TMenuItem;
    Fenetre4: TMenuItem;
    Fenetre5: TMenuItem;
    Fenetre6: TMenuItem;
    Fenetre7: TMenuItem;
    Fenetre8: TMenuItem;
    Fenetre9: TMenuItem;
    CbxHighlighter: TComboBox;
    ToolButton6: TToolButton;
    EnregistrerDos: TMenuItem;
    EnregistrerUnix: TMenuItem;
    EnregistrerMac: TMenuItem;
    EnregistrerSousDos: TMenuItem;
    EnregistrerSousUnix: TMenuItem;
    EnregistrerSousMac: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ActFichierNouveauExecute(Sender: TObject);
    procedure ActFichierOuvrirExecute(Sender: TObject);
    procedure ActFichierReouvrirExecute(Sender: TObject);
    procedure ActFichierEnregistrerExecute(Sender: TObject);
    procedure ActFichierEnregistrerSousExecute(Sender: TObject);
    procedure ActFichierToutEnregistrerExecute(Sender: TObject);
    procedure ActFichierMiseEnPageExecute(Sender: TObject);
    procedure ActFichierApercuExecute(Sender: TObject);
    procedure ActFichierImprimerExecute(Sender: TObject);
    procedure ActFichierFermerExecute(Sender: TObject);
    procedure ActFichierToutFermerExecute(Sender: TObject);
    procedure ActFichierQuitterExecute(Sender: TObject);
    procedure ActEditionDefaireExecute(Sender: TObject);
    procedure ActEditionRefaireExecute(Sender: TObject);
    procedure ActChercherRechercherExecute(Sender: TObject);
    procedure ActChercherDansFichierExecute(Sender: TObject);
    procedure ActChercherRemplacerExecute(Sender: TObject);
    procedure ActChercherSuivantExecute(Sender: TObject);
    procedure ActChercherPrecedentExecute(Sender: TObject);
    procedure ActOutilsPreferencesExecute(Sender: TObject);
    procedure ActAideRubriqueExecute(Sender: TObject);
    procedure ActAideRechercheExecute(Sender: TObject);
    procedure ActAideAProposExecute(Sender: TObject);
    procedure ActAideIndexExecute(Sender: TObject);
    procedure ActUpdateBarreEtatUpdate(Sender: TObject);
    procedure ActEditionDefaireUpdate(Sender: TObject);
    procedure ActEditionRefaireUpdate(Sender: TObject);
    procedure FichierClick(Sender: TObject);
    procedure ReouvrirFichierClick(Sender: TObject);
    procedure AfficheFenetreClick(Sender: TObject);
    procedure ApplicationEventsActionUpdate(Action: TBasicAction;
      var Handled: Boolean);
    procedure ActAllerALaLigneExecute(Sender: TObject);
    procedure ActFichierEnregistrerFormatExecute(Sender: TObject);
    procedure ActFichierEnregistrerSousFormatExecute(Sender: TObject);
    procedure ActFenetreAutresExecute(Sender: TObject);
    procedure FenetreClick(Sender: TObject);
    procedure CbxHighlighterChange(Sender: TObject);
  private
    { Dclarations prives }
    LaLangue: string;
    procedure CreeFicheMDI(const Nom: string);
    procedure GereLangue(Sender: TObject);
    procedure ValideMenu(Autorise: boolean);
    function DejaOuvert(NomFichier: string): boolean;
    procedure SetPreferences(Sender: TObject);
    procedure MajFichiersRecents;
    procedure WMDropFiles(var Mesg: TWMDropFiles); message WM_DROPFILES;
    procedure MajFenetres;
  public
    { Dclarations publiques }
    procedure AjouteSousMenu(Texte: string);
    procedure VideSousMenu;
  end;

const
  VersionSoft: string = '0.2.6';
  NumItemMenuFichiersRecents= 3;

var
  FrmPrincipale: TFrmPrincipale;

implementation

uses Data, Utilitaires, Langues, About, Editeur, Alertes, Preferences,
  MiseEnPage, Apercu, AllerALaLigne, Fenetres;

{$R *.DFM}

{*****************************************************************************}
{ Fonctions private                                                           }
{*****************************************************************************}

procedure TFrmPrincipale.CreeFicheMDI(const Nom: string);
{ Creation d'une nouvelle fenetre MDI }
var
  Child: TFrmEditeur;
  EstVisible: boolean;
  NumLigne: boolean;
  Zero: boolean;
  Maxi: boolean;
begin
  Child := TFrmEditeur.Create(Application);
  Child.Caption := Nom;
  if FileExists(Nom) then Child.SynEdit.Lines.LoadFromFile(Nom);
  Child.SynEdit.Highlighter := DmAppli.GetHighlighterForFile(Nom);
  FrmPreferences.GetEditeur(EstVisible,NumLigne,Zero,Maxi);
  with Child.SynEdit.Gutter do
  begin
    Visible:= EstVisible;
    ShowLineNumbers:= NumLigne;
    LeadingZeros:= Zero;
  end;
  if Maxi then Child.WindowState:= wsMaximized
          else Child.WindowState:= wsNormal;
  DMAppli.AjouteFenetre(Nom);
end;

procedure TFrmPrincipale.GereLangue(Sender: TObject);
{ Gere les evenements dans le menu des langues }
var
  Position: integer;
begin
  with Sender as TMenuItem do
  begin
    LaLangue:= EpureTexte(Caption);
    with MenuPrincipal.Items[NumMenuLangue] do
      for Position:= 1 to Items[NumItemLangue].Count do
        Items[NumItemLangue].Items[Position-1].Checked:= false;
    Checked:= true;
    LitLangue(LaLangue);
  end;
end;

procedure TFrmPrincipale.ValideMenu(Autorise: boolean);
{ Bascule la propriete Enabled des menus }
begin
  ActFichierEnregistrer.Enabled:= Autorise;
  ActFichierEnregistrerSous.Enabled:= Autorise;
  ActFichierToutEnregistrer.Enabled:= Autorise;
  Enregistrerauformat.Enabled:= Autorise;
  Enregistrersousauformat.Enabled:= Autorise;
  ActFichierEnregistrerFormat.Enabled:= Autorise;
  ActFichierEnregistrerSousFormat.Enabled:= Autorise;
  ActFichierMiseEnPage.Enabled:= Autorise;
  ActFichierApercu.Enabled:= Autorise;
  ActFichierImprimer.Enabled:= Autorise;
  ActFichierFermer.Enabled:= Autorise;
  ActFichierToutFermer.Enabled:= Autorise;

  ActEditionDefaire.Enabled:= Autorise;
  ActEditionRefaire.Enabled:= Autorise;

  ActChercherRechercher.Enabled:= Autorise;
  ActChercherDansFichier.Enabled:= Autorise;
  ActChercherRemplacer.Enabled:= Autorise;
  ActChercherSuivant.Enabled:= Autorise and (RecRechercheRemplace.TxtRecherche<>'');
  ActChercherPrecedent.Enabled:= Autorise and (RecRechercheRemplace.TxtRecherche<>'');
  ActAllerALaLigne.Enabled:= Autorise;

  if not Autorise then
  begin
    ActEditionDefaire.Enabled:= false;
    ActEditionRefaire.Enabled:= false;
  end;
end;

function TFrmPrincipale.DejaOuvert(NomFichier: string): boolean;
{ Test si le fichier est dja ouvert dans une fentre        }
{ Si oui, la met en avant plan                               }
var
  Numfils: longint;
  Ouvert: boolean;
begin
  NumFils:= MDIChildCount;
  Ouvert:= false;
  if NumFils>0 then
  begin
    repeat
      dec(NumFils);
      with MDIChildren[NumFils] as TFrmEditeur do Ouvert:= Caption = NomFichier;
    until Ouvert or (NumFils=0);
    if Ouvert then
    begin
      MDIChildren[NumFils].BringToFront;
      DMAppli.FenetresModifies:= true;
    end;
  end;
  result:= Ouvert;
end;

procedure TFrmPrincipale.SetPreferences(Sender: TObject);
{ Gestion des preferences }
var
  N: integer;
  Top: longint;
  Left: longint;
  Height: longint;
  Width: longint;
begin
  FrmPreferences.LitPreferences;
  // Positionne la fenetre
  if Pref.SauveFenetre then
  begin
    FrmPreferences.GetFenetre(Top,Left,Height,Width);
    FrmPrincipale.Top:= Top;
    FrmPrincipale.Left:= Left;
    FrmPrincipale.Height:= Height;
    FrmPrincipale.Width:= Width;
  end
  else
  begin
    FrmPrincipale.Top:= (Screen.Height - FrmPrincipale.Height)div 2;
    FrmPrincipale.Left:= (Screen.Width - FrmPrincipale.Width)div 2;
  end;
  // Selectionne la langue
  LaLangue:= FrmPreferences.GetLangue;
  if not ExisteLangue(LaLangue) then LaLangue:= LangueRef;
  with MenuPrincipal.Items[NumMenuLangue].Items[NumItemLangue]do
  begin
    for N:= 0 to pred(Count) do
      if EpureTexte(Items[N].Caption) = LaLangue then
         Items[N].Checked:= true
      else Items[N].Checked:= false;
  end;
  LitLangue(LaLangue);
end;

procedure TFrmPrincipale.MajFichiersRecents;
{ Affichage de la liste des fichiers recents dans le menu }
var
  N: longint;
  Nom: string;
begin
  for N:= 0 to MaxFichiersRecents do
  begin
    Nom:= DMAppli.LitFichierRecent(N);
    with MenuPrincipal.Items[0].Items[NumItemMenuFichiersRecents].Items[N] do
    begin
      Caption:= IntToStr(N) + ' ' + Nom;
      Visible:= Nom<>'';
    end;
  end;
  DMAppli.FichiersRecentsModifies:= false;
end;

procedure TFrmPrincipale.WMDropFiles(Var Mesg: TWMDropFiles);
{ Gestion des messages Windows de drag and drop  }
var
  NomDuFichier: array[0..255] of Char;
  NbFichiers: longint;
  N: longint;
begin
  //Nombre de fichiers selectionnes dans l'operation de Drag and Drop
  NbFichiers:=DragQueryFile(Mesg.drop, $FFFFFFFF, NomDuFichier, SizeOf(NomDuFichier));
  //Pour chaque fichier
  for N:=0 to NbFichiers - 1 do
  begin
    //Recherche le nom du fichier i
    DragQueryFile(Mesg.drop, N, NomDuFichier, SizeOf(NomDuFichier));
    //Ouverture du fichier s'il n'est pas deja ouvert
    if not DejaOuvert(NomDuFichier) then
    begin
      CreeFicheMDI(NomDuFichier);
      ValideMenu(true);
    end;
  end;
  //Le message a t trait => on renvoit 0 pour cela
  Mesg.result:=0;
  // On autorise le choix de la mise en evidence syntaxique
  if NbFichiers > 0 then CbxHighlighter.Enabled:= true;
  //On ramne en avant
  Application.BringToFront;
  //On prend le focus
  with ActiveMDIChild as TFrmEditeur do SetFocus;
end;

procedure TFrmPrincipale.MajFenetres;
{ Affichage de la liste des fenetres dans le menu }
var
  N: longint;
  Nom: string;
  Actuelle: string;
begin
  Actuelle:= ActiveMDIChild.Caption;
  for N:= 0 to MaxFenetres do
  begin
    Nom:= DMAppli.LitFenetre(N);
    with MenuPrincipal.Items[4].Items[N+6] do
    begin
      Caption:= IntToStr(N) + ' ' + Nom;
      Visible:= Nom<>'';
      Checked:= Nom=Actuelle;
    end;
  end;
  DMAppli.FenetresModifies:= false;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFrmPrincipale.AjouteSousMenu(Texte: string);
{ Ajoute une langue au sous menu de langue }
var
  NewItem: TMenuItem;
begin
  NewItem := TMenuItem.Create(Self);
  NewItem.Caption := Texte;
  with MenuPrincipal.Items[NumMenuLangue].Items[NumItemLangue] do
  begin
    Add(NewItem);
    Items[Count-1].OnClick:= GereLangue;
  end;
end;

procedure TFrmPrincipale.VideSousMenu;
{ Enleve tous les sous menus de langue }
begin
  while MenuPrincipal.Items[NumMenuLangue].Items[NumItemLangue].Count > 0 do
    MenuPrincipal.Items[NumMenuLangue].Items[NumItemLangue].Items[0].free;
end;

{*****************************************************************************}
{ Fiche                                                                       }
{*****************************************************************************}

procedure TFrmPrincipale.FormCreate(Sender: TObject);
begin
  RepAppli := ExtractFilePath(Application.ExeName);
  CreeMenuLangue;
  NomGenerique:= 'SansNom';
  // On accepte les fichiers laches
  DragAcceptFiles(handle, true);
end;

procedure TFrmPrincipale.FormShow(Sender: TObject);
var
 Nom: string;
begin
  // On charge les preferences
  SetPreferences(Sender);
  // On charge la liste des mise en vidence
  DmAppli.GetHighlighterList(CbxHighlighter.Items);
  CbxHighlighter.ItemIndex:= 0;
  // On lit les fichiers recents
  MajFichiersRecents;
  Nom:= paramstr(1);
  if (Nom<>'') and (not DejaOuvert(Nom)) then
  begin
    CreeFicheMDI(Nom);
    ValideMenu(true);
  end;
end;
procedure TFrmPrincipale.FormActivate(Sender: TObject);
begin
  if Pref.Maximiser then WindowState:= wsMaximized
                    else WindowState:= wsNormal;

end;

procedure TFrmPrincipale.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  with FrmPrincipale do
    FrmPreferences.EcritPreferences(Top,Left,Height,Width,LaLangue);
end;

procedure TFrmPrincipale.FichierClick(Sender: TObject);
begin
  Reouvrir.Enabled:= DMAppli.NombreFichiersRecents>0;
  if DMAppli.FichiersRecentsModifies then MajFichiersRecents;
end;

procedure TFrmPrincipale.ReouvrirFichierClick(Sender: TObject);
var
  Nom: string;
  Position: longint;
begin
  Nom:= (Sender as TMenuItem).Caption;
  Position:= pos(' ',Nom);
  if Position > 0 then delete(Nom,1,Position);
  CreeFicheMDI(Nom);
  DMAppli.EnleveFichierRecent(Nom);
  ValideMenu(true);
  // On autorise le choix de la mise en evidence syntaxique
  CbxHighlighter.Enabled:= true;
end;

procedure TFrmPrincipale.FenetreClick(Sender: TObject);
begin
  PlusDeFenetres.Visible:= DMAppli.NombreFenetres>MaxFenetres;
  if DMAppli.FenetresModifies then MajFenetres;
end;

procedure TFrmPrincipale.AfficheFenetreClick(Sender: TObject);
var
  Nom: string;
  Position: longint;
begin
  Nom:= (Sender as TMenuItem).Caption;
  Position:= pos(' ',Nom);
  if Position > 0 then delete(Nom,1,Position);
  DejaOuvert(Nom);
end;

{*****************************************************************************}
{ Actions Fichier                                                             }
{*****************************************************************************}

procedure TFrmPrincipale.ActFichierNouveauExecute(Sender: TObject);
begin
  CreeFicheMDI(NomGenerique + IntToStr(MDIChildCount + 1));
  ValideMenu(true);
  // On autorise le choix de la mise en evidence syntaxique
  CbxHighlighter.Enabled:= true;
end;

procedure TFrmPrincipale.ActFichierOuvrirExecute(Sender: TObject);
var
  N: longint;
begin
  with DmAppli do
  begin
    if DlgOuvrir.Execute then
      with DlgOuvrir.Files do
        for N := 0 to Count - 1 do
        begin
          if not DejaOuvert(Strings[N]) then CreeFicheMDI(Strings[N]);
        end;
  end;
  ValideMenu(true);
  // On autorise le choix de la mise en evidence syntaxique
  CbxHighlighter.Enabled:= true;
end;

procedure TFrmPrincipale.ActFichierReouvrirExecute(Sender: TObject);
begin
//
end;

procedure TFrmPrincipale.ActFichierEnregistrerExecute(Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do Enregistrer('');
end;

procedure TFrmPrincipale.ActFichierEnregistrerSousExecute(Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do
  begin
    DMAppli.EnleveFenetre(Caption);
    EnregistrerSous('');
    DMAppli.AjouteFenetre(Caption);
  end;
end;

procedure TFrmPrincipale.ActFichierToutEnregistrerExecute(Sender: TObject);
var
  N: longint;
begin
  for N:= MDIChildCount-1 downto 0 do
  begin
    with MDIChildren[N] as TFrmEditeur do Enregistrer('');
  end;
end;

procedure TFrmPrincipale.ActFichierEnregistrerFormatExecute(Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do
   with Sender as TMenuItem do Enregistrer(Caption);
end;

procedure TFrmPrincipale.ActFichierEnregistrerSousFormatExecute(
  Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do
  begin
    DMAppli.EnleveFenetre(Caption);
    with Sender as TMenuItem do EnregistrerSous(Caption);
    DMAppli.AjouteFenetre(Caption);
  end;
end;

procedure TFrmPrincipale.ActFichierMiseEnPageExecute(Sender: TObject);
var
  Titre: string;
begin
  Titre:= EpureTexte(ActFichierMiseEnPage.Caption);
  FrmMiseEnPage.SetValeurs(DMAppli.SynEditPrint);
  if FrmMiseEnPage.Execute(Titre) then
    FrmMiseEnPage.GetValeurs(DMAppli.SynEditPrint);
end;

procedure TFrmPrincipale.ActFichierApercuExecute(Sender: TObject);
var
  TitreApercu: string;
  TitreMiseEnPage: string;
begin
  TitreApercu:= EpureTexte(ActFichierApercu.Caption);
  TitreMiseEnPage:= EpureTexte(ActFichierMiseEnPage.Caption);
  with ActiveMDIChild as TFrmEditeur do
  begin
    DMAppli.SynEditPrint.SynEdit:= SynEdit;
    DMAppli.SynEditPrint.Title := Caption;
  end;
  FrmApercu.Execute(TitreApercu, TitreMiseEnPage);
end;

procedure TFrmPrincipale.ActFichierImprimerExecute(Sender: TObject);
begin
  if DMAppli.DlgImprimer.Execute then
  with ActiveMDIChild as TFrmEditeur do
  begin
    DMAppli.SynEditPrint.SynEdit:= SynEdit;
    DMAppli.SynEditPrint.Title := Caption;
    DMAppli.SynEditPrint.Print;
  end;
end;

procedure TFrmPrincipale.ActFichierFermerExecute(Sender: TObject);
begin
  ActiveMDIChild.Close;
end;

procedure TFrmPrincipale.ActFichierToutFermerExecute(Sender: TObject);
var
  N: longint;
begin
  for N:= MDIChildCount-1 downto 0 do MDIChildren[N].Close;
end;

procedure TFrmPrincipale.ActFichierQuitterExecute(Sender: TObject);
begin
  Close;
end;

{*****************************************************************************}
{ Actions Edition                                                             }
{*****************************************************************************}

procedure TFrmPrincipale.ActEditionDefaireExecute(Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do
  begin
    if SynEdit.CanUndo then SynEdit.Undo;
  end;
end;

procedure TFrmPrincipale.ActEditionDefaireUpdate(Sender: TObject);
begin
  if ActiveMDIChild<> nil then
  with ActiveMDIChild as TFrmEditeur do
  begin
    ActEditionDefaire.Enabled:= SynEdit.CanUndo;
  end;
end;

procedure TFrmPrincipale.ActEditionRefaireExecute(Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do
  begin
    if SynEdit.CanRedo then SynEdit.Redo;
  end;
end;

procedure TFrmPrincipale.ActEditionRefaireUpdate(Sender: TObject);
begin
  if ActiveMDIChild<> nil then
  with ActiveMDIChild as TFrmEditeur do
  begin
    ActEditionRefaire.Enabled:= SynEdit.CanRedo;
  end;
end;

{*****************************************************************************}
{ Actions Chercher                                                            }
{*****************************************************************************}

procedure TFrmPrincipale.ActChercherRechercherExecute(Sender: TObject);
begin
  if (ActiveMDIChild as TFrmEditeur).Recherche then
  begin
    ActChercherSuivant.Enabled:= RecRechercheRemplace.TxtRecherche<>'';
    ActChercherPrecedent.Enabled:= RecRechercheRemplace.TxtRecherche<>'';
  end;
end;

procedure TFrmPrincipale.ActChercherDansFichierExecute(Sender: TObject);
begin
//
end;

procedure TFrmPrincipale.ActChercherRemplacerExecute(Sender: TObject);
begin
  if (ActiveMDIChild as TFrmEditeur).Remplace then
  begin
    ActChercherSuivant.Enabled:= RecRechercheRemplace.TxtRecherche<>'';
    ActChercherPrecedent.Enabled:= RecRechercheRemplace.TxtRecherche<>'';
  end;
end;

procedure TFrmPrincipale.ActChercherSuivantExecute(Sender: TObject);
begin
  if RecRechercheRemplace.TxtRecherche<>'' then
    (ActiveMDIChild as TFrmEditeur).RechercheRemplace(false, false);
end;

procedure TFrmPrincipale.ActChercherPrecedentExecute(Sender: TObject);
begin
  if RecRechercheRemplace.TxtRecherche<>'' then
    (ActiveMDIChild as TFrmEditeur).RechercheRemplace(false, true);
end;

procedure TFrmPrincipale.ActAllerALaLigneExecute(Sender: TObject);
var
  Titre: string;
  NumeroDeLigne: longint;
begin
  with TFrmAllerALaLigne.Create(Application)do
  try
    Titre:= EpureTexte(ActAllerALaLigne.Caption);
    NumeroDeLigne:= Execute(Titre,GetMsg(119),GetMsg(120));
  finally
    Free;
  end;
  if NumeroDeLigne>0 then
  with (ActiveMDIChild as TFrmEditeur).Synedit do
  begin
    CaretX:= 0;
    CaretY:= NumeroDeLigne;
  end;
end;

{*****************************************************************************}
{ Actions Outils                                                              }
{*****************************************************************************}

procedure TFrmPrincipale.ActOutilsPreferencesExecute(Sender: TObject);
var
  Titre: string;
  EstVisible: boolean;
  NumLigne: boolean;
  Zero: boolean;
  Maxi: boolean;
  N: longint;
begin
  Titre:= EpureTexte(ActOutilsPreferences.Caption);
  if FrmPreferences.Execute(Titre) then
  begin
    FrmPreferences.GetEditeur(EstVisible,NumLigne,Zero,Maxi);
    for N:= MDIChildCount-1 downto 0 do
    begin
      with MDIChildren[N] as TFrmEditeur do
      begin
        SynEdit.Gutter.Visible:= EstVisible;
        SynEdit.Gutter.ShowLineNumbers:= NumLigne;
        SynEdit.Gutter.LeadingZeros:= Zero;
        if Maxi then WindowState:= wsMaximized
                else WindowState:= wsNormal;
      end;
    end;
    if Pref.Maximiser then FrmPrincipale.WindowState:= wsMaximized
                      else FrmPrincipale.WindowState:= wsNormal;
  end;
end;


{*****************************************************************************}
{ Actions Fenetre                                                             }
{*****************************************************************************}

procedure TFrmPrincipale.ActFenetreAutresExecute(Sender: TObject);
var
  Numero: longint;
  Titre: string;
  Nom: string;
begin
  Titre:= EpureTexte(ActFenetreAutres.Caption);
  FrmFenetres.SetListe(DMAppli.GetListeFenetres);
  Numero:= FrmFenetres.Execute(Titre,GetMsg(119),GetMsg(120));
  if Numero > -1 then
  begin
    Nom:= DMAppli.LitFenetre(Numero);
    DejaOuvert(Nom);
    if Numero > MaxFenetres then DMAppli.DeplaceFenetre(Numero);
  end;
end;

{*****************************************************************************}
{ Actions Aide                                                                }
{*****************************************************************************}

procedure TFrmPrincipale.ActAideRubriqueExecute(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-3;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFrmPrincipale.ActAideIndexExecute(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-2;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFrmPrincipale.ActAideRechercheExecute(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-1;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFrmPrincipale.ActAideAProposExecute(Sender: TObject);
begin
  with TFAbout.Create(Application) do
    try Showmodal;
    finally Free;
    end;
end;

{*****************************************************************************}
{ Actions Fiche                                                               }
{*****************************************************************************}

procedure TFrmPrincipale.ActUpdateBarreEtatUpdate(Sender: TObject);
var
  PosCurseur: TPoint;
  Mode: string;
begin
  if ActiveMDIChild <> nil then
  with ActiveMDIChild as TFrmEditeur do
  begin
    // Position du curseur
    PosCurseur := SynEdit.CaretXY;
    if (PosCurseur.X > 0) and (PosCurseur.Y > 0) then
      BarreEtat.Panels[0].Text := Format(' %6d:%3d ', [PosCurseur.Y, PosCurseur.X])
    else
      BarreEtat.Panels[0].Text := '';
    // Modifie
    if SynEdit.Modified then
      BarreEtat.Panels[1].Text := GetMsg(101)
    else
      BarreEtat.Panels[1].Text := '';
    // Insertion / Remplacement
    if SynEdit.ReadOnly then Mode := GetMsg(102)
    else
      if SynEdit.InsertMode then Mode := GetMsg(103)
                            else Mode := GetMsg(104);
    BarreEtat.Panels[2].Text := Mode;
    // Language
    if SynEdit.Highlighter <> nil then
      BarreEtat.Panels[3].Text := SynEdit.Highlighter.LanguageName
    else
      BarreEtat.Panels[3].Text := '?????';
    if (not CbxHighlighter.DroppedDown) and
      (CbxHighlighter.Text <> BarreEtat.Panels[3].Text) then
       CbxHighlighter.ItemIndex:=
         CbxHighlighter.Items.IndexOf(BarreEtat.Panels[3].Text);
  end else begin
    BarreEtat.Panels[0].Text := '';
    BarreEtat.Panels[1].Text := '';
    BarreEtat.Panels[2].Text := '';
    BarreEtat.Panels[3].Text := '';
  end;
end;

procedure TFrmPrincipale.ApplicationEventsActionUpdate(
  Action: TBasicAction; var Handled: Boolean);
begin
  if MDIChildCount = 0 then
  begin
    ValideMenu(false);
    // On autorise plus le choix de la mise en evidence syntaxique
    CbxHighlighter.Enabled:= false;
  end;
end;

procedure TFrmPrincipale.CbxHighlighterChange(Sender: TObject);
begin
  with ActiveMDIChild as TFrmEditeur do
  begin
    SynEdit.Highlighter:= DmAppli.GetHighlighter(CbxHighlighter.Text);
  end;
end;

end.
