unit Apercu;

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ImgList, ToolWin, SynEditPrintPreview, ActnList;

type
  TFrmApercu = class(TForm)
    TBarNavigation: TToolBar;
    IlNavigation: TImageList;
    TBtnPremiere: TToolButton;
    TBtnPrecedente: TToolButton;
    TBtnSuivante: TToolButton;
    TBtnDerniere: TToolButton;
    ToolButton5: TToolButton;
    TBtnZoomMoins: TToolButton;
    TBtnZoomPlus: TToolButton;
    SynEditPrintPreview: TSynEditPrintPreview;
    ToolButton1: TToolButton;
    SBarApercu: TStatusBar;
    ToolButton2: TToolButton;
    TBtnMiseEnPage: TToolButton;
    TBtnImprimer: TToolButton;
    ALstApercu: TActionList;
    ActPremiere: TAction;
    ActPrecedente: TAction;
    ActSuivante: TAction;
    ActDerniere: TAction;
    ActZoomMoins: TAction;
    ActZoomPlus: TAction;
    ActMiseEnPage: TAction;
    ActImprimer: TAction;
    TBtnPageEntiere: TToolButton;
    ActPageEntiere: TAction;
    procedure FormShow(Sender: TObject);
    procedure SynEditPrintPreviewMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ActPremiereExecute(Sender: TObject);
    procedure ActPrecedenteExecute(Sender: TObject);
    procedure ActSuivanteExecute(Sender: TObject);
    procedure ActDerniereExecute(Sender: TObject);
    procedure ActZoomMoinsExecute(Sender: TObject);
    procedure ActZoomPlusExecute(Sender: TObject);
    procedure ActImprimerExecute(Sender: TObject);
    procedure ActMiseEnPageExecute(Sender: TObject);
    procedure SynEditPrintPreviewPreviewPage(Sender: TObject;
      PageNumber: Integer);
    procedure ActPageEntiereExecute(Sender: TObject);
  private
    { Dclarations prives }
    procedure ValideZoom;
    procedure AfficheNumPage;
  public
    { Dclarations publiques }
    procedure Execute(TitreApercu, TitreMiseEnPage: string);
  end;

var
  FrmApercu: TFrmApercu;
  Titre: string;

implementation

{$R *.DFM}

uses Data, MiseEnPage;

{*****************************************************************************}
{ Fonctions de la fiche                                                       }
{*****************************************************************************}

procedure TFrmApercu.FormShow(Sender: TObject);
begin
  SynEditPrintPreview.UpdatePreview;
  SynEditPrintPreview.FirstPage;
  SynEditPrintPreview.ScaleMode:= pscWholePage;
  ValideZoom;
  AfficheNumPage;
  SBarApercu.Update;
end;

procedure TFrmApercu.SynEditPrintPreviewMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then ActZoomPlus.Execute
                     else ActZoomMoins.Execute;
end;

{*****************************************************************************}
{ Actions                                                                     }
{*****************************************************************************}

procedure TFrmApercu.ActPremiereExecute(Sender: TObject);
begin
  SynEditPrintPreview.FirstPage;
end;

procedure TFrmApercu.ActPrecedenteExecute(Sender: TObject);
begin
  SynEditPrintPreview.PreviousPage;
end;

procedure TFrmApercu.ActSuivanteExecute(Sender: TObject);
begin
  SynEditPrintPreview.NextPage;
end;

procedure TFrmApercu.ActDerniereExecute(Sender: TObject);
begin
  SynEditPrintPreview.LastPage;
end;

procedure TFrmApercu.ActPageEntiereExecute(Sender: TObject);
begin
  SynEditPrintPreview.ScaleMode:= pscWholePage;
end;

procedure TFrmApercu.ActZoomMoinsExecute(Sender: TObject);
var
  FScale: Integer;
begin
  FScale := SynEditPrintPreview.ScalePercent;
  if SynEditPrintPreview.ScaleMode = pscWholePage then FScale := 25
  else
  begin
    FScale := FScale div 2;
    if FScale < 25 then FScale := 25;
  end;
  SynEditPrintPreview.ScalePercent := FScale;
  ValideZoom;
end;

procedure TFrmApercu.ActZoomPlusExecute(Sender: TObject);
var
  FScale: Integer;
begin
  FScale := SynEditPrintPreview.ScalePercent;
  if SynEditPrintPreview.ScaleMode = pscWholePage then FScale := 100
  else
  begin
    FScale := FScale * 2;
    if FScale > 400 then FScale := 400;
  end;
  SynEditPrintPreview.ScalePercent := FScale;
  ValideZoom;
end;

procedure TFrmApercu.ActMiseEnPageExecute(Sender: TObject);
begin
  FrmMiseEnPage.SetValeurs(DMAppli.SynEditPrint);
  if FrmMiseEnPage.Execute(Titre) then
  begin
    FrmMiseEnPage.GetValeurs(DMAppli.SynEditPrint);
    SynEditPrintPreview.UpdatePreview;
    SynEditPrintPreview.Refresh;
  end;
end;

procedure TFrmApercu.ActImprimerExecute(Sender: TObject);
begin
  SynEditPrintPreview.Print;
end;

{*****************************************************************************}
{ Fonctions privee                                                            }
{*****************************************************************************}

procedure TFrmApercu.ValideZoom;
begin
  ActZoomMoins.Enabled:= not (SynEditPrintPreview.ScalePercent=25);
  ActZoomPlus.Enabled:= not (SynEditPrintPreview.ScalePercent=400);
end;

procedure TFrmApercu.AfficheNumPage;
var
  Texte: string;
begin
  Texte:= '  ' + IntToStr(SynEditPrintPreview.PageNumber) + ' / ';
  Texte:= Texte + IntToStr(SynEditPrintPreview.SynEditPrint.PageCount);
  SBarApercu.SimpleText := Texte;
end;

{*****************************************************************************}
{ Fonctions public                                                            }
{*****************************************************************************}

procedure TFrmApercu.Execute(TitreApercu, TitreMiseEnPage: string);
begin
  Titre:= TitreMiseEnPage;
  Caption:= TitreApercu;
  ShowModal;
end;

procedure TFrmApercu.SynEditPrintPreviewPreviewPage(Sender: TObject;
  PageNumber: Integer);
begin
  AfficheNumPage;
end;

end.
