unit RSView;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// File viewer for that project                                            //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SynEdit, ExtCtrls, ImgList, ComCtrls, ToolWin;

type
  TFView = class(TForm)
    PnlBottom: TPanel;
    SynEdit: TSynEdit;
    BtnQuit: TButton;
    ToolBar: TToolBar;
    TbnOpen: TToolButton;
    ToolButton2: TToolButton;
    TbnSave: TToolButton;
    ToolButton4: TToolButton;
    TbnSaveAs: TToolButton;
    ImageList: TImageList;
    DlgOpen: TOpenDialog;
    DlgSave: TSaveDialog;
    ChbxReadOnly: TCheckBox;
    procedure SynEditChange(Sender: TObject);
    procedure PnlBottomResize(Sender: TObject);
    procedure ChbxReadOnlyClick(Sender: TObject);
    procedure TbnOpenClick(Sender: TObject);
    procedure TbnSaveClick(Sender: TObject);
    procedure TbnSaveAsClick(Sender: TObject);
    procedure BtnQuitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Dclarations prives }
    Filename: TFilename;
    procedure InitLanguage;
  public
    { Dclarations publiques }
    procedure Execute(AFilename: TFilename);
  end;

var
  FView: TFView;

implementation

{$R *.dfm}

uses
  RSLng;

const
  NullCarView = #1;

{*****************************************************************************}
{ Form function                                                               }
{*****************************************************************************}

procedure TFView.FormCreate(Sender: TObject);
begin
  InitLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFView.SynEditChange(Sender: TObject);
begin
  TbnSave.Visible:= SynEdit.Modified;
  TbnSaveAs.Visible:= SynEdit.Modified;
end;

{------------------------------------------------------------------------------}

procedure TFView.PnlBottomResize(Sender: TObject);
begin
  BtnQuit.Left:= (Width - BtnQuit.Width) - 15;
end;

{------------------------------------------------------------------------------}

procedure TFView.ChbxReadOnlyClick(Sender: TObject);
begin
  SynEdit.ReadOnly:= ChbxReadOnly.Checked;
end;

{------------------------------------------------------------------------------}

procedure TFView.TbnOpenClick(Sender: TObject);
begin
  if DlgOpen.Execute then
  begin
    Filename:= DlgOpen.FileName;
    SynEdit.Lines.LoadFromFile(Filename);
    Caption:= Filename;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFView.TbnSaveClick(Sender: TObject);
var
  AStream: TMemoryStream;
  AChar: char;
  N: longint;
begin
  // Reverse NullCarView to #0
  AStream:= TMemoryStream.Create;
  SynEdit.Lines.SaveToStream(AStream);
  AStream.Position:= 0;
  for N:= 1 to AStream.Size do
  begin
    AStream.Read(AChar,1);
    if AChar=NullCarView then
    begin
      AChar:= #0;
      AStream.Position:= AStream.Position - 1;
      AStream.Write(AChar,1);
    end;
  end;
  AStream.SaveToFile(Filename);
  AStream.Free;
end;

{------------------------------------------------------------------------------}

procedure TFView.TbnSaveAsClick(Sender: TObject);
var
  Done: boolean;
begin
  Done:= false;
  while not Done do
  begin
    if DlgSave.Execute then
    begin
      Filename:= DlgSave.FileName;
      TbnSaveClick(self);
      Caption:= Filename;
      Done:= true;
    end
    else Done:= true;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFView.BtnQuitClick(Sender: TObject);
begin
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFView.FormShow(Sender: TObject);
begin
  ChbxReadOnly.Checked:= true;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFView.InitLanguage;
begin
  TbnOpen.Hint:= GetMsg(171);
  TbnSave.Hint:= GetMsg(172);
  TbnSaveAs.Hint:= GetMsg(173);
  ChbxReadOnly.Caption:= GetMsg(174);
  BtnQuit.Caption:= GetMsg(175);
  BtnQuit.Hint:= GetMsg(176);
end;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}

procedure TFView.Execute(AFilename: TFilename);
var
  N: longint;
  AStream: TMemoryStream;
  AChar: char;
begin
  Filename:= AFilename;
  // Replace #0 by NullCarView to show them
  // as #0 is interpreted as EOL by SynEdit
  AStream:= TMemoryStream.Create;
  AStream.LoadFromFile(AFilename);
  AStream.Position:= 0;
  for N:= 1 to AStream.Size do
  begin
    AStream.Read(AChar,1);
    if AChar=#0 then
    begin
      AChar:= NullCarView;
      AStream.Position:= AStream.Position - 1;
      AStream.Write(AChar,1);
    end;
  end;
  SynEdit.Lines.LoadFromStream(AStream);
  Caption:= Filename;
  ShowModal;
  AStream.Free;
end;

end.
