unit RSThumb;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TFThumb = class(TForm)
    ImgThumb: TImage;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure Display(path, filename: TFilename);
  end;

var
  FThumb: TFThumb;

implementation

{$R *.dfm}

uses jpeg, graphicEx, RSCommon;

{ TFThumb }

procedure TFThumb.Display(path, filename: TFilename);
var
  Found: boolean;
  ImgFilename: TFilename;
  CoefX, CoefY: double;
  TitleWidth: integer;
begin
  Found:= false;
  // Found if we have a corresponding picture with the different allowed extensions
  ImgFilename:= ChangeFileExt(filename, '.bmp');
  if FileExists(path + ImgFilename) then Found:= true;
  if not Found then
  begin
    ImgFilename:= ChangeFileExt(filename, '.png');
    if FileExists(path + ImgFilename) then Found:= true;
  end;
  if not Found then
  begin
    ImgFilename:= ChangeFileExt(filename, '.jpg');
    if FileExists(path + ImgFilename) then Found:= true;
  end;

  if not Found then Hide
  else
  begin
    // Display it (max defined in preferences
    ImgThumb.Picture.LoadFromFile(path + ImgFilename);
    CoefX:= AppliCfg.ThumbWidth / ImgThumb.Picture.Width;
    CoefY:= AppliCfg.ThumbHeight / ImgThumb.Picture.Height;
    if CoefX <= CoefY then
    begin
      ImgThumb.Width:= round(ImgThumb.Picture.Width * CoefX);
      ImgThumb.Height:= round(ImgThumb.Picture.Height * CoefX);
    end
    else
    begin
      ImgThumb.Width:= round(ImgThumb.Picture.Width * CoefY);
      ImgThumb.Height:= round(ImgThumb.Picture.Height * CoefY);
    end;
    Caption:= ImgFilename;
    TitleWidth:= (length(ImgFilename) + 2) * 7;
    if TitleWidth > ImgThumb.Width then ImgThumb.Width:= TitleWidth;
    // Size adjustment before display
    Width:= ImgThumb.Width;
    Height:= ImgThumb.Height+20;
    Show;
  end;
end;

end.
