unit RSSelnam;
/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Configutaion name selection for that project                            //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFSelectName = class(TForm)
    LblCfgNameTitle: TLabel;
    EdtCfgName: TEdit;
    BtnOK: TButton;
    BtnCancel: TButton;
    procedure BtnOKClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure EdtCfgNameKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EdtCfgNameKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
  private
    { Dclarations prives }
    Answer: boolean;
    SerialCfgList: TStrings;
    procedure InitLanguage;
  public
    { Dclarations publiques }
    function Execute(AStringList: TStrings; AName: string): string;
  end;

var
  FSelectName: TFSelectName;

implementation

{$R *.DFM}

uses
  RSLng, RSMsg;

{*****************************************************************************}
{ Form function                                                               }
{*****************************************************************************}

procedure TFSelectName.FormCreate(Sender: TObject);
begin
  InitLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFSelectName.BtnOKClick(Sender: TObject);
begin
  if EdtCfgName.Text= '' then
  begin
    ShowError(EdtCfgName,GetMsg(213),[]);
    EdtCfgName.SetFocus;
  end
  else
    if SerialCfgList.IndexOf(EdtCfgName.Text)<>-1 then
    begin
      ShowError(EdtCfgName,GetMsg(214),[EdtCfgName.Text]);
      EdtCfgName.SetFocus;
    end
    else
    begin
      Answer:= true;
      Close;
    end;
end;

{------------------------------------------------------------------------------}

procedure TFSelectName.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFSelectName.EdtCfgNameKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then perform(WM_NEXTDLGCTL,0,0);
end;

{------------------------------------------------------------------------------}

procedure TFSelectName.EdtCfgNameKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then key:= #0;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFSelectName.InitLanguage;
begin
  Caption:= GetMsg(101);
  LblCfgNameTitle.Caption:= GetMsg(102);
  BtnOk.Caption:= GetMsg(103);
  BtnOk.Hint:= GetMsg(104);
  BtnCancel.Caption:= GetMsg(105);
  BtnCancel.Hint:= GetMsg(106);
  EdtCfgName.Text:= GetMsg(107);
end;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}

function TFSelectName.Execute(AStringList: TStrings; AName: string): string;
begin
  Answer:= false;
  SerialCfgList:= AStringList;
  if AName <> '' then EdtCfgName.Text:= AName;
  ShowModal;
  if Answer then Result:= EdtCfgName.Text
            else Result:= '';
end;

end.
