unit RSSeldir;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Directory selection form for that project                               //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FileCtrl, StdCtrls, ExtCtrls;

type
  TFSelectDir = class(TForm)
    LblSelectedDirTitle: TLabel;
    LblSelectedDir: TLabel;
    Bevel1: TBevel;
    DcbDrive: TDriveComboBox;
    DlbDirectory: TDirectoryListBox;
    BtnOk: TButton;
    BtnCancel: TButton;
    FlbFile: TFileListBox;
    BtnNewDir: TButton;
    procedure FormCreate(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure BtnAnnulerClick(Sender: TObject);
    procedure BtnNewDirClick(Sender: TObject);
  private
    { Dclarations prives }
    SelectedDir: string;
    procedure InitLanguage;
  public
    { Dclarations publiques }
    function Execute(ADirectory: string): string;
  end;

var
  FSelectDir: TFSelectDir;
  Answer: boolean;

implementation

{$R *.DFM}

uses
  RScommon, RSlng;

{*****************************************************************************}
{ Form function                                                               }
{*****************************************************************************}

procedure TFSelectDir.FormCreate(Sender: TObject);
begin
  InitLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFSelectDir.BtnOKClick(Sender: TObject);
begin
  SelectedDir:= DlbDirectory.Directory;
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFSelectDir.BtnAnnulerClick(Sender: TObject);
begin
  SelectedDir:= '';
  Close;
end;

{------------------------------------------------------------------------------}

procedure TFSelectDir.BtnNewDirClick(Sender: TObject);
// Make a new sub-directory in the current directory
var
 NewString,s: String;
 ClickedOK: Boolean;
begin
  NewString := '';
  ClickedOK := InputQuery(GetMsg(119),GetMsg(120), NewString);
  if ClickedOK and (NewString<>'') then
  begin
     {$I-}
     s:=DlbDirectory.Directory;
     if s[length(s)]<>'\' then NewString:='\'+NewString;
     MkDir(DlbDirectory.Directory+NewString);
     if IOResult <> 0 then
       MessageDlgPos(GetMsg(121),mtError, [mbOk], 0, Left, Top)
     else
        DlbDirectory.Directory:=DlbDirectory.Directory+NewString;
    {$I+}
  end;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFSelectDir.InitLanguage;
begin
  Caption:= GetMsg(111);
  LblSelectedDirTitle.Caption:= GetMsg(112);
  BtnOk.Caption:= GetMsg(113);
  BtnOk.Hint:= GetMsg(114);
  BtnCancel.Caption:= GetMsg(115);
  BtnCancel.Hint:= GetMsg(116);
  BtnNewDir.Caption:= GetMsg(117);
  BtnNewDir.Hint:= GetMsg(118);
end;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}

function TFSelectDir.Execute(ADirectory: string):string;
var
  AString: string;
begin
  Answer:= false;
  if ADirectory = '' then ADirectory:= AppliDir;
  AString:= ExtractFileDrive(ADirectory);
  DcbDrive.Drive:= AString[1];
  AString:= ExtractFilePath(ADirectory);
  delete(AString,1,2);
  DlbDirectory.Directory:= AString;
  ShowModal;
  Result:= SelectedDir;
end;

{------------------------------------------------------------------------------}

end.
