unit RSPref;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Preference management for that project                                  //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TFPreference = class(TForm)
    BtnOk: TButton;
    BtnCancel: TButton;
    PctrlPref: TPageControl;
    TshSave: TTabSheet;
    TshLog: TTabSheet;
    GbxSave: TGroupBox;
    ChbLanguage: TCheckBox;
    ChbMachine: TCheckBox;
    ChbMainWindow: TCheckBox;
    ChbLvFileList: TCheckBox;
    GbxLog: TGroupBox;
    ChbLogfile: TCheckBox;
    ChbLogStatus: TCheckBox;
    ChbLogTiming: TCheckBox;
    ChbLogCode: TCheckBox;
    ChbLogData: TCheckBox;
    TshInfo: TTabSheet;
    GbxInfo: TGroupBox;
    ChbSignals: TCheckBox;
    TshThumb: TTabSheet;
    GbxThumb: TGroupBox;
    CbxDisplayThumb: TCheckBox;
    LblThumbWidth: TLabel;
    EdtThumbWidth: TEdit;
    LblThumbHeight: TLabel;
    EdtThumbHeight: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure ChbLogfileClick(Sender: TObject);
    procedure EdtThumbKeyPress(Sender: TObject; var Key: Char);
    procedure CbxDisplayThumbClick(Sender: TObject);
  private
    { Dclarations prives }
    procedure InitLanguage;
    procedure InitDisplay;
  public
    { Dclarations publiques }
    procedure Execute;
  end;

var
  FPreference: TFPreference;

implementation

{$R *.dfm}

uses
  RSCommon, RSLng;

{ TFPreference }

{*****************************************************************************}
{ Form function                                                               }
{*****************************************************************************}

procedure TFPreference.FormCreate(Sender: TObject);
begin
  InitLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFPreference.ChbLogfileClick(Sender: TObject);
begin
  ChbLogStatus.Enabled:= ChbLogFile.Checked;
  ChbLogTiming.Enabled:= ChbLogFile.Checked;
  ChbLogCode.Enabled:= ChbLogFile.Checked;
  ChbLogData.Enabled:= ChbLogFile.Checked;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFPreference.InitLanguage;
begin
  Caption:= GetMsg(141);

  BtnOk.Caption:= GetMsg(004);
  BtnOk.Hint:= GetMsg(005);
  BtnCancel.Caption:= GetMsg(006);
  BtnCancel.Hint:= GetMsg(007);

  TshSave.Caption:= GetMsg(142);
  GbxSave.Caption:= GetMsg(143);
  ChbLanguage.Caption:= GetMsg(144);
  ChbMachine.Caption:= GetMsg(145);
  ChbMainWindow.Caption:= GetMsg(146);
  ChbLvFileList.Caption:= GetMsg(147);
  TshLog.Caption:=GetMsg(151);
  GbxLog.Caption:= GetMsg(152);
  ChbLogfile.Caption:= GetMsg(153);
  ChbLogStatus.Caption:= GetMsg(154);
  ChbLogTiming.Caption:= GetMsg(155);
  ChbLogCode.Caption:= GetMsg(156);
  ChbLogData.Caption:= GetMsg(157);
  TshInfo.Caption:=GetMsg(158);
  GbxInfo.Caption:= GetMsg(159);
  ChbSignals.Caption:= GetMsg(160);
  TshThumb.Caption:= GetMsg(161);
  GbxThumb.Caption:= GetMsg(162);
  CbxDisplayThumb.Caption:= GetMsg(163);
  LblThumbWidth.Caption:= GetMsg(164);
  LblThumbHeight.Caption:= GetMsg(165);
end;

{------------------------------------------------------------------------------}

procedure TFPreference.InitDisplay;
begin
  with AppliCfg do
  begin
    ChbLanguage.Checked:= SaveLanguage;
    ChbMachine.Checked:= SaveMachine;
    ChbMainWindow.Checked:= SaveMainWindow;
    ChbLvFileList.Checked:= SaveFileListDisplay;
    ChbLogFile.Checked:= LogFile;
    ChbLogStatus.Checked:= LogStatus;
    ChbLogTiming.Checked:= LogTiming;
    ChbLogCode.Checked:= LogCode;
    ChbLogData.Checked:= LogData;
    ChbLogStatus.Enabled:= ChbLogFile.Checked;
    ChbLogTiming.Enabled:= ChbLogFile.Checked;
    ChbLogCode.Enabled:= ChbLogFile.Checked;
    ChbLogData.Enabled:= ChbLogFile.Checked;
    ChbSignals.Checked:= InfoSignals;
    CbxDisplayThumb.Checked:= Thumbnails;
    EdtThumbWidth.Text:= IntToStr(ThumbWidth);
    EdtThumbHeight.Text:= IntToStr(ThumbHeight);
  end;
  PctrlPref.ActivePage:= TshSave;
end;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}
procedure TFPreference.Execute;
begin
  InitDisplay;
  if ShowModal = mrOk then
  begin
    with AppliCfg do
    begin
      SaveLanguage:= ChbLanguage.Checked;
      SaveMachine:= ChbMachine.Checked;
      SaveMainWindow:= ChbMainWindow.Checked;
      SaveFileListDisplay:= ChbLvFileList.Checked;
      LogFile:= ChbLogFile.Checked;
      LogStatus:= ChbLogStatus.Checked;
      LogTiming:= ChbLogTiming.Checked;
      LogCode:= ChbLogCode.Checked;
      LogData:= ChbLogData.Checked;
      InfoSignals:= ChbSignals.Checked;
      Thumbnails:= CbxDisplayThumb.Checked;
      try
        ThumbWidth:= StrToInt(EdtThumbWidth.Text);
      except
        ThumbWidth:= ThumbDefaultWidth;
      end;
      try
        ThumbHeight:= StrToInt(EdtThumbHeight.Text);
      except
        ThumbHeight:= ThumbDefaultHeight;
      end;
    end;
  end;
end;

procedure TFPreference.EdtThumbKeyPress(Sender: TObject;
  var Key: Char);
begin
  // #8 is Backspace
  if not (Key in [#8, '0'..'9']) then begin
    // Discard the key
    Key := #0;
  end;
end;

procedure TFPreference.CbxDisplayThumbClick(Sender: TObject);
begin
  LblThumbWidth.Enabled:= CbxDisplayThumb.Checked;
  LblThumbHeight.Enabled:= CbxDisplayThumb.Checked;
  EdtThumbWidth.Enabled:= CbxDisplayThumb.Checked;
  EdtThumbHeight.Enabled:= CbxDisplayThumb.Checked;
end;

end.
