unit RSMsg;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Error and messages display for that project                             //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ImgList, ExtCtrls;

type
  TFMessage = class(TForm)
    PnlBottom: TPanel;
    PnlLeft: TPanel;
    LblMessage: TLabel;
    ImgMessage: TImage;
    ImlMessage: TImageList;
    BtnOk: TButton;
    BtnCancel: TButton;
  private
    { Dclarations prives }
    function GetWidth(AString: string): integer;
    function AdjustText(AText: string; Args: array of const): string;
    procedure AdjustPos(AControl: TControl);
  public
    { Dclarations publiques }
  end;

  function ShowError(AControl: TControl; AText: string; Args: array of const): word;
  function ShowInfo(AControl: TControl; AText: string; Args: array of const): word;
  function ShowOkCancel(AControl: TControl; AText: string; Args: array of const): word;
  function ShowYesNo(AControl: TControl; AText: string; Args: array of const): word;

var
  FMessage: TFMessage;

implementation

{$R *.dfm}

uses
  RSlng;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

function TFMessage.GetWidth(AString: string): integer;
var
  APos: integer;
  TmpText: string;
  TmpWidth: integer;
begin
  Result:= 0;
  while length(AString) > 0 do
  begin
    APos:= pos('\n',AString);
    if APos = 0 then APos:= length(AString);
    TmpText:= copy(AString,1,APos);
    delete(AString,1,APos);
    TmpWidth:= LblMessage.Canvas.TextWidth(TmpText);
    if TmpWidth > Result then Result:= TmpWidth;
  end;
end;

{------------------------------------------------------------------------------}

function TFMessage.AdjustText(AText: string; Args: array of const): string;
var
  AString: string;
  AWidth: integer;
begin
  AString:= Format(AText,Args);
  AWidth:= GetWidth(AString);
  Result:= StringReplace(AString,'\n',#13#10,[rfReplaceAll]);
  // Adapt message width for that text
  Width:= AWidth + ImgMessage.Width + 30;
end;

{------------------------------------------------------------------------------}

procedure TFMessage.AdjustPos(AControl: TControl);
var
  P: TPoint;
begin
  ImgMessage.Top:= (PnlLeft.Height - ImgMessage.Height) div 2;
  ImgMessage.Left:= (PnlLeft.Width - ImgMessage.Width) div 2;
  if (AControl is TForm) then
  begin
    P.X:= (AControl.ClientWidth - FMessage.Width) div 2;
    P.Y:= (AControl.ClientHeight - FMessage.Height) div 2;
  end
  else
  begin
    P.X:= 0;
    P.Y:= AControl.Height;
  end;
  P:= AControl.ClientToScreen(P);
  Left:= P.X;
  Top:= P.Y;
end;

{------------------------------------------------------------------------------}
{*****************************************************************************}
{ General function                                                            }
{*****************************************************************************}

function ShowError(AControl: TControl; AText: string; Args: array of const): word;
var
  AString: string;
begin
  FMessage:= TFMessage.Create(AControl);
  FMessage.Width:= 640;
  with FMessage do
  try
    AString:= AdjustText(AText, Args);
    // Adaptation
    Caption:= GetMsg(201);
    ImlMessage.GetBitmap(0,ImgMessage.Picture.Bitmap);
    LblMessage.Caption:= AString;
    BtnOk.Caption:= GetMsg(204);
    BtnOk.ModalResult:= mrOk;
    BtnOk.Visible:= true;
    BtnCancel.Visible:= false;
    BtnOk.Left:= (PnlBottom.Width - BtnOk.Width) div 2;
    // Position
    AdjustPos(AControl);
    // Show
    Result:= ShowModal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

function ShowInfo(AControl: TControl; AText: string; Args: array of const): word;
var
  AString: string;
begin
  FMessage:= TFMessage.Create(AControl);
  FMessage.Width:= 640;
  with FMessage do
  try
    AString:= AdjustText(AText, Args);
    // Adaptation
    Caption:= GetMsg(202);
    ImlMessage.GetBitmap(1,ImgMessage.Picture.Bitmap);
    LblMessage.Caption:= AString;
    BtnOk.Caption:= GetMsg(204);
    BtnOk.ModalResult:= mrOk;
    BtnOk.Visible:= true;
    BtnCancel.Visible:= false;
    BtnOk.Left:= (PnlBottom.Width - BtnOk.Width) div 2;
    // Position
    AdjustPos(AControl);
    // Show
    Result:= ShowModal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

function ShowOkCancel(AControl: TControl; AText: string; Args: array of const): word;
var
  AString: string;
begin
  FMessage:= TFMessage.Create(AControl);
  FMessage.Width:= 640;
  with FMessage do
  try
    AString:= AdjustText(AText, Args);
    // Adaptation
    Caption:= GetMsg(203);
    ImlMessage.GetBitmap(2,ImgMessage.Picture.Bitmap);
    LblMessage.Caption:= AString;
    BtnOk.Caption:= GetMsg(204);
    BtnOk.ModalResult:= mrOk;
    BtnOk.Visible:= true;
    BtnCancel.Caption:= GetMsg(205);
    BtnCancel.ModalResult:= mrCancel;
    BtnCancel.Visible:= true;
    BtnOk.Left:= (PnlBottom.Width div 4) - (BtnOk.Width div 2);
    BtnCancel.Left:= (3 * (PnlBottom.Width div 4)) - (BtnCancel.Width div 2);
    // Position
    AdjustPos(AControl);
    // Show
    Result:= ShowModal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

function ShowYesNo(AControl: TControl; AText: string; Args: array of const): word;
var
  AString: string;
begin
  FMessage:= TFMessage.Create(AControl);
  FMessage.Width:= 640;
  with FMessage do
  try
    AString:= AdjustText(AText, Args);
    // Adaptation
    Caption:= GetMsg(203);
    ImlMessage.GetBitmap(2,ImgMessage.Picture.Bitmap);
    LblMessage.Caption:= AString;
    BtnOk.Caption:= GetMsg(206);
    BtnOk.ModalResult:= mrYes;
    BtnOk.Visible:= true;
    BtnCancel.Caption:= GetMsg(207);
    BtnCancel.ModalResult:= mrNo;
    BtnCancel.Visible:= true;
    BtnOk.Left:= (PnlBottom.Width div 4) - (BtnOk.Width div 2);
    BtnCancel.Left:= (3 * (PnlBottom.Width div 4)) - (BtnCancel.Width div 2);
    // Position
    AdjustPos(AControl);
    // Show
    Result:= ShowModal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}


end.
