unit RSLng;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Language management for that project                                    //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

const
  MaxMsg = 300;        // Maximum number of stored messages

var
  Msg: array[0..MaxMsg] of string;

  procedure CreateLanguageFile;
  function ExistLanguage(ALanguage: string): boolean;
  procedure LoadLanguage(ALanguage: string);
  function GetMsg(Num: longint): string;

implementation

uses
  Forms, SysUtils, RScommon, RSmain;

{*****************************************************************************}
{ Messages management                                                         }
{*****************************************************************************}

procedure ClearMsg;
// Clear all messages
var
  N: integer;
begin
  for N:= 0 to MaxMsg do Msg[N]:= '';
end;

{------------------------------------------------------------------------------}

procedure StoreMsg(ANumber: longint;AText: string);
// Store a new message in the list
begin
  Msg[ANumber]:= AText;
end;

{------------------------------------------------------------------------------}

function GetMsg(Num: longint): string;
begin
  result:= Msg[Num];
end;

{*****************************************************************************}
{ Language file creation                                                      }
{*****************************************************************************}

procedure CreateLanguageFile;
// Create the basic language file
var
  LngFile: textfile;
  LngFilename: TFilename;

  procedure CreateHeader;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Fichier de langue de RS232 V1.2                                            }');
    writeln(LngFile,'{ Franais                                                                   }');
    writeln(LngFile,'{                                                                            }');
    writeln(LngFile,'{ Pour crer d''autres langues, copier ce fichier en le renommant du nom de la}');
    writeln(LngFile,'{ langue mais en gardant l''extension LRS                                     }');
    writeln(LngFile,'{ Exemple: pour l''anglais le fichier s''appellera English.LRS                 }');
    writeln(LngFile,'{                                                                            }');
    writeln(LngFile,'{ Les passages entre { et } sont des commentaires.                           }');
    writeln(LngFile,'{ Ne pas modifier les lignes avant le #.                                     }');
    writeln(LngFile,'{ Traduire tout ce qui se trouve aprs #.                                    }');
    writeln(LngFile,'{ Le & prcde la lettre de raccourci clavier que l''on obtiendra avec Alt    }');
    writeln(LngFile,'{ %s reprsente une chane qui sera insre                                  }');
    writeln(LngFile,'{ \n ralise un retour  la ligne                                            }');

    writeln(LngFile,'{----------------------------------------------------------------------------}');
  end;

  procedure CreateMainMenu;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Menu principal                                                             }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0001#&Fichier');
    writeln(LngFile,'0009#&Quitter');
    writeln(LngFile,'0010#Quitte le programme');
    writeln(LngFile,'0011#O&utils');
    writeln(LngFile,'0012#&Configuration machines...');
    writeln(LngFile,'0013#Permet de configurer les machines');
    writeln(LngFile,'0014#&Langues');
    writeln(LngFile,'0015#Permet de choisir la langue d''affichage');
    writeln(LngFile,'0016#&Prfrences...');
    writeln(LngFile,'0017#Permet de choisir les prfrences  sauvegarder en quittant');
    writeln(LngFile,'0021#&Aide');
    writeln(LngFile,'0022#&Rubrique d''aide');
    writeln(LngFile,'0023#Aide du programme');
    writeln(LngFile,'0024#Re&cherche');
    writeln(LngFile,'0025#Recherche dans les diffrentes rubriques de l''aide');
    writeln(LngFile,'0026#&A propos...');
    writeln(LngFile,'0027#Informations concernant le programme');
  end;

  procedure CreateLeftPanel;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Panneau gauche                                                             }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0101#PC');
    writeln(LngFile,'0102#Choix du lecteur');
    writeln(LngFile,'0103#Remonte au rpertoire prcdent');
    writeln(LngFile,'0104#Cre un nouveau rpertoire');
    writeln(LngFile,'0105#Petites icnes');
    writeln(LngFile,'0106#Liste');
    writeln(LngFile,'0107#Dtails');
    writeln(LngFile,'0108#Rafrachit l''affichage de la liste des fichiers');
    writeln(LngFile,'0111#Nom');
    writeln(LngFile,'0112#Taille');
    writeln(LngFile,'0113#Date');
    writeln(LngFile,'0114#Connect');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Menu popup panneau gauche                                                  }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0201#Rafrachit');
    writeln(LngFile,'0202#Rafrachit l''affichage de la liste des fichiers');
    writeln(LngFile,'0203#Visualise');
    writeln(LngFile,'0204#Affiche le contenu du fichier');
  end;

  procedure CreateRightPanel;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Panneau droit                                                              }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'0301#Machine');
    writeln(LngFile,'0302#&Machine connecte :');
    writeln(LngFile,'0303#Choix de la machine connecte');
    writeln(LngFile,'0304#Permet de configurer les transmissions');
    writeln(LngFile,'0305#Suivi des oprations :');
    writeln(LngFile,'0306#Liste des oprations');
    writeln(LngFile,'0307#&Recevoir');
    writeln(LngFile,'0308#Met le PC en mode rception');
    writeln(LngFile,'0309#&Envoyer');
    writeln(LngFile,'0310#Met le PC en mode mission');
    writeln(LngFile,'0311#Annuler');
    writeln(LngFile,'0312#Annule la transmission en cours');
    writeln(LngFile,'0313#Caractres transmis :');
    writeln(LngFile,'0314#Dconnecte');
    writeln(LngFile,'0315#Dconnecte la machine (ferme le port srie)');
  end;

  procedure CreateConfiguration;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Bote de configuration                                                     }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1001#Configuration');
    writeln(LngFile,'1002#Nom de la configuration :');
    writeln(LngFile,'1003#Choix de la configuration  visualiser');
    writeln(LngFile,'1004#&Ok');
    writeln(LngFile,'1005#Applique ces nouveaux rglages');
    writeln(LngFile,'1006#Annuler');
    writeln(LngFile,'1007#Annule les modifications effectues non enregistres');
    writeln(LngFile,'1008#&Enregistrer');
    writeln(LngFile,'1009#Enregistre cette configuration');
    writeln(LngFile,'1010#Gnrale');
    writeln(LngFile,'1011# Rpertoire de travail');
    writeln(LngFile,'1012#Rpertoire de travail');
    writeln(LngFile,'1013#Choix du rpertoire');
    writeln(LngFile,'1014# Dbut et fin de transmission');
    writeln(LngFile,'1015#Code de dbut :');
    writeln(LngFile,'1016#Code de dbut de transmission');
    writeln(LngFile,'1017#Choix du code de dbut');
    writeln(LngFile,'1018#Code de fin :');
    writeln(LngFile,'1019#Code de fin de transmission');
    writeln(LngFile,'1020#Choix du code de fin');
    writeln(LngFile,'1021#Port srie');
    writeln(LngFile,'1022#Codage :');
    writeln(LngFile,'1023#Choix du codage utilis. ISO = 7 bits, parit paire     EIA = 8 bits pas de parit');
    writeln(LngFile,'1024#sans');
    writeln(LngFile,'1025#Port :');
    writeln(LngFile,'1026#Choix du port srie');
    writeln(LngFile,'1027#Vitesse :');
    writeln(LngFile,'1028#Choix de la vitesse');
    writeln(LngFile,'1029#Parit :');
    writeln(LngFile,'1030#Choix de la parit');
    writeln(LngFile,'1031#sans');
    writeln(LngFile,'1032#paire');
    writeln(LngFile,'1033#impaire');
    writeln(LngFile,'1034#Bits de donnes :');
    writeln(LngFile,'1035#Choix du nombre de bits de donnes');
    writeln(LngFile,'1036#Bits d''arrts :');
    writeln(LngFile,'1037#Choix du nombre de bits d''arrts');
    writeln(LngFile,'1038#Contrle de flux :');
    writeln(LngFile,'1039#Choix du contrle de flux');
    writeln(LngFile,'1040#sans');
    writeln(LngFile,'1041#CTS/RTS');
    writeln(LngFile,'1042#XON/XOFF');
    writeln(LngFile,'1043#mission');
    writeln(LngFile,'1044# Nombre de caractres NUL');
    writeln(LngFile,'1045#Dbut de transmission :');
    writeln(LngFile,'1046#Nombre de caractres NUL mis avant le dbut de transmission');
    writeln(LngFile,'1047#Fin de transmission:');
    writeln(LngFile,'1048#Nombre de caractres NUL mis aprs la fin de transmission');
    writeln(LngFile,'1049# Prliminaires');
    writeln(LngFile,'1050#Message d''attente');
    writeln(LngFile,'1051#Affichage d''un message demandant de mettre la machine en rception');
    writeln(LngFile,'1052#Nombre de lignes  supprimer :');
    writeln(LngFile,'1053#Nombre de lignes  supprimer avant de transmettre');
    writeln(LngFile,'1054#Recherche dbut/fin');
    writeln(LngFile,'1055#Recherche le code de dbut de transmission avant d''mettre');
    writeln(LngFile,'1056#Laisser le port srie ouvert');
    writeln(LngFile,'1057#Laisse le port srie ouvert en fin de transmission. Ncessaire pour certains quipements (Moxa par exemple)');
    writeln(LngFile,'1058#Rception');
    writeln(LngFile,'1059# Prliminaires');
    writeln(LngFile,'1060#Nombre de lignes  supprimer :');
    writeln(LngFile,'1061#Nombre de lignes  supprimer avant de stocker');
    writeln(LngFile,'1062#Recherche dbut/fin');
    writeln(LngFile,'1063#Recherche le code de dbut de transmission avant de stocker');
    writeln(LngFile,'1064#Code mission');
    writeln(LngFile,'1065#Code de demande d''mission');
    writeln(LngFile,'1066#Choix du code de demande d''mission');
    writeln(LngFile,'1067#Attente demande mission');
    writeln(LngFile,'1068#Attente du code demandant d''mettre');
    writeln(LngFile,'1069#Demande d''mission');
    writeln(LngFile,'1070#Envoi du code demandant d''mettre');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Menu contextuel bote de configuration                                     }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1081#&Nouvelle');
    writeln(LngFile,'1082#&Copier');
    writeln(LngFile,'1083#&Supprimer');
	writeln(LngFile,'1084#&Exporter...');
	writeln(LngFile,'1085#&Importer...');
  end;

  procedure CreateSelection;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Bote de choix du nom                                                      }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1101#Choix du nom');
    writeln(LngFile,'1102#Nom de la configuration :');
    writeln(LngFile,'1103#&OK');
    writeln(LngFile,'1104#Accepte le nom fourni');
    writeln(LngFile,'1105#A&nnuler');
    writeln(LngFile,'1106#Annule le choix');
    writeln(LngFile,'1107#SansNom');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Bote de choix du repertoire                                               }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1111#Choix du rpertoire');
    writeln(LngFile,'1112#Rpertoire slectionn :');
    writeln(LngFile,'1113#&Ok');
    writeln(LngFile,'1114#Accepte le rpertoire slectionn');
    writeln(LngFile,'1115#A&nnuler');
    writeln(LngFile,'1116#Annule le choix');
    writeln(LngFile,'1117#Crer rep.');
    writeln(LngFile,'1118#Cre un nouveau rpertoire ici');
    writeln(LngFile,'1119#Crer un nouveau sous-rpertoire');
    writeln(LngFile,'1120#Rpertoire');
    writeln(LngFile,'1121#Impossible de crer ce rpertoire');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Table des caractres                                                       }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1131#Choisissez un caractre');
    writeln(LngFile,'1132#Ok');
    writeln(LngFile,'1133#Accepte la slection');
    writeln(LngFile,'1134#Annuler');
    writeln(LngFile,'1135#Ignore la slection');
    writeln(LngFile,'1136#Slectionn :');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Prfrences                                                                }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1141#Prfrences');
    writeln(LngFile,'1142#Sauvegarde');
    writeln(LngFile,'1143#Sauver en quittant :');
    writeln(LngFile,'1144#Langue utilise');
    writeln(LngFile,'1145#Machine utilise');
    writeln(LngFile,'1146#Position et taille de la fentre');
    writeln(LngFile,'1147#Type d''affichage de la liste des fichiers');
    writeln(LngFile,'1151#Log');
    writeln(LngFile,'1152# Fichiers de log');
    writeln(LngFile,'1153#Activ');
    writeln(LngFile,'1154#Statut');
    writeln(LngFile,'1155#Chronologie');
    writeln(LngFile,'1156#Codes');
    writeln(LngFile,'1157#Donnes');
    writeln(LngFile,'1158#Info');
    writeln(LngFile,'1159# Informations');
    writeln(LngFile,'1160#Signaux');
    writeln(LngFile,'1161#Miniatures');
    writeln(LngFile,'1162# Miniatures');
    writeln(LngFile,'1163#Afficher');
    writeln(LngFile,'1164#Largeur (pixels)');
    writeln(LngFile,'1165#Hauteur (pixels)');
  end;

  procedure CreateEditor;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Visualiseur                                                                }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1171#Ouvre un fichier');
    writeln(LngFile,'1172#Enregistre ce fichier');
    writeln(LngFile,'1173#Enregistre ce fichier en choisissant un nom');
    writeln(LngFile,'1174#Lecture seule');
    writeln(LngFile,'1175#Quitte');
    writeln(LngFile,'1176#Quitte l''diteur');
  end;

  procedure CreateMessages;
  begin
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Messages                                                                   }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1201#Erreur');
    writeln(LngFile,'1202#Information');
    writeln(LngFile,'1203#Confirmation');
    writeln(LngFile,'1204#&Ok');
    writeln(LngFile,'1205#&Annuler');
    writeln(LngFile,'1206#&Oui');
    writeln(LngFile,'1207#&Non');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Messages de configuration                                                  }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1211#Le fichier RS232.CRS est endommag !');
    writeln(LngFile,'1212#"%s" n''est pas une valeur correcte');
    writeln(LngFile,'1213#Vous devez donner un nom pour cette configuration !');
    writeln(LngFile,'1214#"%s" est un nom dj utilis !');
    writeln(LngFile,'1215#"%s" n''est pas un code valable.\n Il doit tre entre 0 et 255 !');
    writeln(LngFile,'1216#Voulez-vous supprimer "%s" ?');
    writeln(LngFile,'1217#Fichier de configuration incorrect.');
    writeln(LngFile,'1218#Fichiers de configuration dans :');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Messages d''mission                                                        }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1231#Mettre la machine en attente de rception.');
    writeln(LngFile,'1232#Impossible de supprimer %s lignes .\n Le fichier est trop petit.');
    writeln(LngFile,'1233#Il n''y a pas de code "%s" dans ce fichier .');
    writeln(LngFile,'1234#mission de : %s');
    writeln(LngFile,'1235#mission termine.');
    writeln(LngFile,'1236#mission interrompue !');
    writeln(LngFile,'1237#Rception de : %s');
    writeln(LngFile,'1238#Rception termine.');
    writeln(LngFile,'1239#Rception interrompue !');
    writeln(LngFile,'1240#Caractres transmis :');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'{ Messages de reception                                                      }');
    writeln(LngFile,'{----------------------------------------------------------------------------}');
    writeln(LngFile,'1251#Fichier "%s" existant. craser ?');
    writeln(LngFile,'1260#Caractres reus:');
  end;

begin
  LngFilename:= AppliDir + RefLng + LngExt;
  AssignFile(LngFile,LngFilename);
  rewrite(LngFile);

  CreateHeader;
  CreateMainMenu;
  CreateLeftPanel;
  CreateRightPanel;
  CreateConfiguration;
  CreateSelection;
  CreateEditor;
  CreateMessages;

  closefile(LngFile);
end;

{*****************************************************************************}
{ Language file management                                                    }
{*****************************************************************************}

function ExistLanguage(ALanguage: string): boolean;
var
  LngFilename: TFilename;
begin
  LngFilename:= AppliDir + ALanguage + LngExt;
  result:= FileExists(LngFilename);
end;

{------------------------------------------------------------------------------}

procedure ParseLine(ALine: string; var ANumber: longint; var AText: string);
// Divide a line Number#Text into 2 different entities ANumber and AText
var
  N: integer;
begin
  N:= pos('#',ALine);
  if N <> 0 then
  begin
    ANumber:= StrToInt(copy(ALine,1,N-1));
    delete(ALine,1,N);
    AText:= ALine;
  end
  else
  begin
    ANumber:= 0;
    AText:= '';
  end;
end;

{------------------------------------------------------------------------------}

procedure ProcessLine(ALine: string);
// Process a line of a language file
var
  ANumber: longint;
  AText: string;
begin
  ParseLine(ALine,ANumber,AText);
  case ANumber of
    // Main menu
    0001: FMain.MnuMain.Items[FileMnuIndex].Caption:= AText;
    0009: FMain.ActFileQuit.Caption:= AText;
    0010: FMain.ActFileQuit.Hint:= AText;
    0011: FMain.MnuMain.Items[ToolMnuIndex].Caption:= AText;
    0012: FMain.ActConfigSerial.Caption:= AText;
    0013: FMain.ActConfigSerial.Hint:= AText;
    0014: FMain.MnuMain.Items[ToolMnuIndex].Items[1].Caption:= AText;
    0015: FMain.MnuMain.Items[ToolMnuIndex].Items[1].Hint:= AText;
    0016: FMain.MnuMain.Items[ToolMnuIndex].Items[2].Caption:= AText;
    0017: FMain.MnuMain.Items[ToolMnuIndex].Items[2].Hint:= AText;
    0021: FMain.MnuMain.Items[HelpMnuIndex].Caption:= AText;
    0022: FMain.MnuMain.Items[HelpMnuIndex].Items[0].Caption:= AText;
    0023: FMain.MnuMain.Items[HelpMnuIndex].Items[0].Hint:= AText;
    0024: FMain.MnuMain.Items[HelpMnuIndex].Items[1].Caption:= AText;
    0025: FMain.MnuMain.Items[HelpMnuIndex].Items[1].Hint:= AText;
    0026: FMain.MnuMain.Items[HelpMnuIndex].Items[3].Caption:= AText;
    0027: FMain.MnuMain.Items[HelpMnuIndex].Items[3].Hint:= AText;
    // Left panel
    0101: FMain.PnlPCTitle.Caption:= AText;
    0102: FMain.DcbPCDriveList.Hint:= AText;
    0103: FMain.ActPreviousDir.Hint:= AText;
    0104: FMain.ActNewDir.Hint:= AText;
    0105: FMain.ActSmallIcon.Hint:= AText;
    0106: FMain.ActList.Hint:= AText;
    0107: FMain.ActDetail.Hint:= AText;
    0111: FMain.LvFileList.Columns[0].Caption:= AText;
    0112: FMain.LvFileList.Columns[1].Caption:= AText;
    0113: FMain.LvFileList.Columns[2].Caption:= AText;
    0114: FMain.LblConn.Caption:= AText;
    // Left panel popup menu
    0201: FMain.PopMnuPCFileList.Items[0].Caption:= AText;
    0202: FMain.PopMnuPCFileList.Items[0].Hint:= AText;
    0203: FMain.PopMnuPCFileList.Items[1].Caption:= AText;
    0204: FMain.PopMnuPCFileList.Items[1].Hint:= AText;
    // Right panel
    0301: FMain.PnlMachineTitle.Caption:= AText;
    0302: FMain.LblMachine.Caption:= AText;
    0303: FMain.ActChangeMachine.Hint:= AText;
    0304: FMain.ActEditMachine.Hint:= AText;
    0305: FMain.LblFollowup.Caption:= AText;
    0306: FMain.MemFollowup.Hint:= AText;
    0307: FMain.ActReceive.Caption:= AText;
    0308: FMain.ActReceive.Hint:= AText;
    0309: FMain.ActSend.Caption:= AText;
    0310: FMain.ActSend.Hint:= AText;
    0311: FMain.ActCancel.Caption:= AText;
    0312: FMain.ActCancel.Hint:= AText;
    0313: FMain.LblTransmittedCharTitle.Caption:= AText;
    0314: FMain.ActDisconnect.Caption:= AText;
    0315: FMain.ActDisconnect.Hint:= AText;
  else
    if ANumber > 1000 then StoreMsg(ANumber mod 1000,AText);
  end;
end;

{------------------------------------------------------------------------------}

procedure LoadLanguage(ALanguage: string);
// Load the corresponding language for GUI and help
var
  ALine: string;
  LngFile: textfile;
  LngFilename: TFilename;
  HelpFilename: TFilename;
begin
  // Language file
  ALanguage:= LowerCaseText(ALanguage);
  if not ExistLanguage(ALanguage) then ALanguage:= RefLng;
  LngFilename:= AppliDir + ALanguage + LngExt;
  // Load language data
  AssignFile(LngFile,LngFilename);
  reset(LngFile);
  while not Eof(LngFile) do
  begin
    readln(LngFile,ALine);
    ALine:= trim(ALine);
    if ((ALine<>'') and (ALine[1]<>'{')) then  ProcessLine(ALine);
  end;
  closefile(LngFile);

  // Help file
  HelpFilename:= AppliDir + ALanguage + HelpExt;
  if FileExists(HelpFilename) then
  begin
    Application.HelpFile:= HelpFilename;
    FMain.ActHelpChapter.Visible:= true;
    FMain.ActHelpFind.Visible:= true;
  end
  else
  begin
    Application.HelpFile:= '';
    FMain.ActHelpChapter.Visible:= false;
    FMain.ActHelpFind.Visible:= false;
  end;
end;

end.