unit RSConfig;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Configuration form for that project                                     //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, Forms, Menus, StdCtrls, CPortCtl, Buttons, Controls,
  ComCtrls, Classes, Dialogs,
  RSCfgmng;

type
  TFConfig = class(TForm)
    LblConfigName: TLabel;
    CbxConfigName: TComboBox;
    PgCtrlConfig: TPageControl;
    TshGeneral: TTabSheet;
    TshComPort: TTabSheet;
    TshSend: TTabSheet;
    TshReceive: TTabSheet;
    GbxCode: TGroupBox;
    LblStartCode: TLabel;
    EdtStartCode: TEdit;
    LblEndCode: TLabel;
    EdtEndCode: TEdit;
    LblCoding: TLabel;
    CbxCoding: TComboBox;
    SbnCoding: TSpeedButton;
    GbxNullChar: TGroupBox;
    LblStartNullChar: TLabel;
    EdtStartNullChar: TEdit;
    LblEndNullChar: TLabel;
    EdtEndNullChar: TEdit;
    GbxWorkingDir: TGroupBox;
    EdtWorkingDir: TEdit;
    SbnWorkingDir: TSpeedButton;
    GbxComPort: TGroupBox;
    LblComPort: TLabel;
    CbxComPort: TComComboBox;
    LblSpeed: TLabel;
    CbxSpeed: TComComboBox;
    LblParity: TLabel;
    CbxParity: TComboBox;
    LblDataBits: TLabel;
    CbxDataBits: TComComboBox;
    LblStopBits: TLabel;
    CbxStopBits: TComComboBox;
    LblFlowControl: TLabel;
    CbxFlowControl: TComboBox;
    GbxBeforeSend: TGroupBox;
    LblSendRemoveLines: TLabel;
    ChbSendFindStartEnd: TCheckBox;
    ChbMessageBefore: TCheckBox;
    EdtSendRemoveLines: TEdit;
    GbxBeforeReceive: TGroupBox;
    LblReceiveRemoveLines: TLabel;
    EdtReceiveRemoveLines: TEdit;
    ChbReceiveFindStartEnd: TCheckBox;
    BtnCancel: TButton;
    BtnOk: TButton;
    BtnSave: TButton;
    PopupConfig: TPopupMenu;
    MnuItemNew: TMenuItem;
    MnuItemCopy: TMenuItem;
    N1: TMenuItem;
    MnuItemDelete: TMenuItem;
    SbnStartCode: TSpeedButton;
    SbnEndCode: TSpeedButton;
    ChbSendWaitSignal: TCheckBox;
    LblSendCode: TLabel;
    EdtSendCode: TEdit;
    SbnSendCode: TSpeedButton;
    ChbReceiveWaitSignal: TCheckBox;
    MnuItemExport: TMenuItem;
    MnuItemImport: TMenuItem;
    DlgOpen: TOpenDialog;
    DlgSave: TSaveDialog;
    ChbStayOpen: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CbxConfigNameChange(Sender: TObject);
    procedure SbnWorkingDirClick(Sender: TObject);
    procedure EdtStartCodeExit(Sender: TObject);
    procedure EdtStartCodeKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EdtStartCodeKeyPress(Sender: TObject; var Key: Char);
    procedure SbnStartCodeClick(Sender: TObject);
    procedure SbnEndCodeClick(Sender: TObject);
    procedure SbnSendCodeClick(Sender: TObject);
    procedure EdtStartNullCharExit(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
    procedure PopupConfigPopup(Sender: TObject);
    procedure MnuItemNewClick(Sender: TObject);
    procedure MnuItemCopyClick(Sender: TObject);
    procedure MnuItemDeleteClick(Sender: TObject);
    procedure MnuItemExportClick(Sender: TObject);
    procedure MnuItemImportClick(Sender: TObject);
  private
    { Dclarations prives }
    DisplayedCfgSerial: TCfgSerial;
    procedure InitLanguage;
    procedure InitDisplay;
    procedure ChangeConfig;
  public
    { Dclarations publiques }
    function Execute(ACfgSerial: TCfgSerial; Modify: boolean): boolean;
  end;

var
  FConfig: TFConfig;

implementation

{$R *.DFM}

uses
  SysUtils, RSCommon, RSLng, RSMsg, RSSelnam, RSSeldir, RSChrtbl;

{*****************************************************************************}
{ Form function                                                               }
{*****************************************************************************}

procedure TFConfig.FormCreate(Sender: TObject);
begin
  InitLanguage;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.FormShow(Sender: TObject);
begin
  PgCtrlConfig.ActivePage:= TshGeneral;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.CbxConfigNameChange(Sender: TObject);
begin
  DisplayedCfgSerial.LoadFromFile(SerialCfgFilename,CbxConfigName.Text);
  InitDisplay;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.SbnWorkingDirClick(Sender: TObject);
var
  Answer: string;
begin
  with TFSelectDir.Create(Self)do
  try
    Answer:= Execute(EdtWorkingDir.Text);
    if Answer <> '' then EdtWorkingDir.Text:= Answer;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.EdtStartCodeExit(Sender: TObject);
begin
  if (Sender as TEdit).Text <> '' then
  begin
    if not CheckNumValue((Sender as TEdit).Text,0,255) then
    begin
      ShowError((Sender as TEdit),GetMsg(215),[(Sender as TEdit).Text]);
      (Sender as TEdit).SetFocus;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.EdtStartCodeKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then perform(WM_NEXTDLGCTL,0,0);
end;

{------------------------------------------------------------------------------}

procedure TFConfig.EdtStartCodeKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#8,'0'..'9']) then
  begin
    Beep;
    Key:= #0;
  end;
  if key=#13 then key:= #0;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.SbnStartCodeClick(Sender: TObject);
var
  Answer: byte;
begin
  with TFCharTable.Create(Self)do
  try
    Answer:= Execute;
    if Answer<>0 then EdtStartCode.Text:= IntToStr(Answer);
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.SbnEndCodeClick(Sender: TObject);
var
  Answer: byte;
begin
  with TFCharTable.Create(Self)do
  try
    Answer:= Execute;
    if Answer<>0 then EdtEndCode.Text:= IntToStr(Answer);
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.SbnSendCodeClick(Sender: TObject);
var
  Answer: byte;
begin
  with TFCharTable.Create(Self)do
  try
    Answer:= Execute;
    if Answer<>0 then EdtSendCode.Text:= IntToStr(Answer);
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.EdtStartNullCharExit(Sender: TObject);
begin
  if (Sender as TEdit).Text = '' then (Sender as TEdit).Text:= '0';
  if not CheckNumValue((Sender as TEdit).Text,0,MaxInt) then
  begin
    ShowError((Sender as TEdit),GetMsg(212),[(Sender as TEdit).Text]);
    (Sender as TEdit).SetFocus;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.BtnSaveClick(Sender: TObject);
begin
  ChangeConfig;
  DisplayedCfgSerial.SaveToFile(SerialCfgFilename,DisplayedCfgSerial.ConfigName);
end;

{------------------------------------------------------------------------------}

procedure TFConfig.PopupConfigPopup(Sender: TObject);
begin
  MnuItemDelete.Enabled:= (CbxConfigName.Items.Count > 1) and
    (DisplayedCfgSerial.ConfigName <> CurrentCfg.ConfigName);
end;

{------------------------------------------------------------------------------}

procedure TFConfig.MnuItemNewClick(Sender: TObject);
var
  AName: string;
begin
  with TFSelectName.Create(Self) do
  try
    AName:= Execute(CbxConfigName.Items,'');
    if AName <> '' then
    begin
      Cursor:= CrHourGlass;
      DisplayedCfgSerial.InitToDefault;
      DisplayedCfgSerial.ConfigName:= AName;
      CbxConfigName.Items.Add(AName);
      CbxConfigName.ItemIndex:= CbxConfigName.Items.IndexOf(AName);
      InitDisplay;
      DisplayedCfgSerial.SaveToFile(SerialCfgFilename,DisplayedCfgSerial.ConfigName);
      Cursor:= CrDefault;
    end;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.MnuItemCopyClick(Sender: TObject);
var
  AName: string;
begin
  with TFSelectName.Create(Self) do
  try
    AName:= Execute(CbxConfigName.Items,'');
    if AName <> '' then
    begin
      Cursor:= CrHourGlass;
      CbxConfigName.Items.Add(AName);
      CbxConfigName.ItemIndex:= CbxConfigName.Items.IndexOf(AName);
      BtnSaveClick(Sender);
      Cursor:= CrDefault;
    end;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.MnuItemExportClick(Sender: TObject);
var
  TmpFilename: TFilename;
  Answer: boolean;
begin
  // Select save filename
  DlgSave.FileName:=CbxConfigName.Items[CbxConfigName.ItemIndex] + ExportCfgExt;
  DlgSave.InitialDir:= AppliCfgDir;
  repeat
    Answer:= DlgSave.Execute;
    if Answer then
    begin
      TmpFilename:= DlgSave.Filename;
      if FileExists(TmpFilename) then
        Answer:= ShowYesNo(Self,GetMsg(251),[TmpFilename]) = mrYes;
    end
    else
    begin
      TmpFilename:= '';
      Answer:= true;
    end;
  until Answer;
  // Save if needed
  if TmpFilename <> '' then
  begin
    ChangeConfig;
    DisplayedCfgSerial.ExportToFile(DlgSave.FileName,DisplayedCfgSerial.ConfigName);
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.MnuItemImportClick(Sender: TObject);
var
  TmpFilename: TFilename;
  Answer: boolean;
  AName: string;
begin
  // Select file
  DlgOpen.InitialDir:= AppliCfgDir;
  Answer:= DlgOpen.Execute;
  if Answer then
  begin
    TmpFilename:= DlgOpen.Filename;
    if TmpFilename <> '' then
    begin
      if DisplayedCfgSerial.ImportFromFile(TmpFilename) then
      begin
        with TFSelectName.Create(Self) do
        try
          AName:= Execute(CbxConfigName.Items,DisplayedCfgSerial.ConfigName);
          if AName <> '' then
          begin
            Cursor:= CrHourGlass;
            DisplayedCfgSerial.ConfigName:= AName;
            CbxConfigName.Items.Add(AName);
            InitDisplay;
            BtnSaveClick(Sender);
            Cursor:= CrDefault;
          end;
        finally
          Free;
        end;
      end
      else
      begin
        ShowError(Self,GetMsg(217),[]);
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.MnuItemDeleteClick(Sender: TObject);
begin
  if CbxConfigName.Items.Count > 1 then
  begin
    if ShowYesNo(Self,GetMsg(216),[DisplayedCfgSerial.ConfigName]) = mrYes then
    begin
      Cursor:= CrHourGlass;
      DisplayedCfgSerial.DeleteFromFile(SerialCfgFilename,DisplayedCfgSerial.ConfigName);
      CbxConfigName.Items.Delete(
        CbxConfigName.Items.IndexOf(DisplayedCfgSerial.ConfigName));
      DisplayedCfgSerial.LoadFromFile(SerialCfgFilename,CbxConfigName.Items[0]);
      InitDisplay;
      Cursor:= CrDefault;
    end;
  end;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFConfig.InitLanguage;
begin
  Caption:= GetMsg(001);
  LblConfigName.Caption:= GetMsg(002);
  CbxConfigName.Hint:= GetMsg(003);

  BtnOk.Caption:= GetMsg(004);
  BtnOk.Hint:= GetMsg(005);
  BtnCancel.Caption:= GetMsg(006);
  BtnCancel.Hint:= GetMsg(007);
  BtnSave.Caption:= GetMsg(008);
  BtnSave.Hint:= GetMsg(009);

  TshGeneral.Caption:= GetMsg(010);
  GbxWorkingDir.Caption:= GetMsg(011);
  EdtWorkingDir.Hint:= GetMsg(012);
  SbnWorkingDir.Hint:= GetMsg(013);
  GbxCode.Caption:= GetMsg(014);
  LblStartCode.Caption:= GetMsg(015);
  EdtStartCode.Hint:= GetMsg(016);
  SbnStartCode.Hint:= GetMsg(017);
  LblEndCode.Caption:= GetMsg(018);
  EdtEndCode.Hint:= GetMsg(019);
  SbnEndCode.Hint:= GetMsg(020);
  LblSendCode.Caption:= GetMsg(062);
  EdtSendCode.Hint:= GetMsg(063);
  SbnSendCode.Hint:= GetMsg(064);
  TshComPort.Caption:= GetMsg(021);
  LblCoding.Caption:= GetMsg(022);
  CbxCoding.Hint:= GetMsg(023);
  CbxCoding.Items[0]:= GetMsg(024);
  LblComPort.Caption:= GetMsg(025);
  CbxComPort.Hint:= GetMsg(026);
  LblSpeed.Caption:= GetMsg(027);
  CbxSpeed.Hint:= GetMsg(028);
  LblParity.Caption:= GetMsg(029);
  CbxParity.Hint:= GetMsg(030);
  CbxParity.Items[0]:= GetMsg(031);
  CbxParity.Items[1]:= GetMsg(032);
  CbxParity.Items[2]:= GetMsg(033);
  LblDataBits.Caption:= GetMsg(034);
  CbxDataBits.Hint:= GetMsg(035);
  LblStopBits.Caption:= GetMsg(036);
  CbxStopBits.Hint:= GetMsg(037);
  LblFlowControl.Caption:= GetMsg(038);
  CbxFlowControl.Hint:= GetMsg(039);
  CbxFlowControl.Items[0]:= GetMsg(040);
  CbxFlowControl.Items[1]:= GetMsg(041);
  CbxFlowControl.Items[2]:= GetMsg(042);

  TshSend.Caption:= GetMsg(043);
  GbxNullChar.Caption:= GetMsg(044);
  LblStartNullChar.Caption:= GetMsg(045);
  EdtStartNullChar.Hint:= GetMsg(046);
  LblEndNullChar.Caption:= GetMsg(047);
  EdtEndNullChar.Hint:= GetMsg(048);
  GbxBeforeSend.Caption:= GetMsg(049);
  ChbMessageBefore.Caption:= GetMsg(050);
  ChbMessageBefore.Hint:= GetMsg(051);
  LblSendRemoveLines.Caption:= GetMsg(052);
  EdtSendRemoveLines.Hint:= GetMsg(053);
  ChbSendFindStartEnd.Caption:= GetMsg(054);
  ChbSendFindStartEnd.Hint:= GetMsg(055);
  ChbSendWaitSignal.Caption:= GetMsg(067);
  ChbSendWaitSignal.Hint:= GetMsg(068);
  ChbStayOpen.Caption:= GetMsg(056);
  ChbStayOpen.Hint:= GetMsg(057);

  TshReceive.Caption:= GetMsg(058);
  GbxBeforeReceive.Caption:= GetMsg(059);
  LblReceiveRemoveLines.Caption:= GetMsg(060);
  EdtReceiveRemoveLines.Hint:= GetMsg(061);
  ChbReceiveFindStartEnd.Caption:= GetMsg(062);
  ChbReceiveFindStartEnd.Hint:= GetMsg(063);
  ChbReceiveWaitSignal.Caption:= GetMsg(069);
  ChbReceiveWaitSignal.Hint:= GetMsg(070);

  PopupConfig.Items[0].Caption:= GetMsg(081);
  PopupConfig.Items[1].Caption:= GetMsg(082);
  PopupConfig.Items[2].Caption:= GetMsg(084);
  PopupConfig.Items[3].Caption:= GetMsg(085);
  PopupConfig.Items[5].Caption:= GetMsg(083);
end;

{------------------------------------------------------------------------------}

procedure TFConfig.InitDisplay;
begin
  with DisplayedCfgSerial do
  begin
    // General
    CbxConfigName.ItemIndex:= CbxConfigName.Items.IndexOf(ConfigName);
    EdtWorkingDir.Text:= WorkingDir;
    EdtStartCode.Text:= StartCode;
    EdtEndCode.Text:= EndCode;
    EdtSendCode.Text:= SendCode;
    // Com port
    CbxCoding.ItemIndex:= Coding;
    CbxComPort.ItemIndex:= CbxComPort.Items.IndexOf(Port);
    CbxSpeed.ItemIndex:= CbxSpeed.Items.IndexOf(Speed);
    CbxParity.ItemIndex:= Parity;
    CbxDataBits.ItemIndex:= CbxDataBits.Items.IndexOf(DataBits);
    CbxStopBits.ItemIndex:= CbxStopBits.Items.IndexOf(StopBits);
    CbxFlowControl.ItemIndex:= FlowControl;
    // Send
    EdtStartNullChar.Text:= StartNullChar;
    EdtEndNullChar.Text:= EndNullChar;
    ChbMessageBefore.Checked:= MessageBefore;
    EdtSendRemoveLines.Text:= SendRemoveLines;
    ChbSendFindStartEnd.Checked:= SendFindStartEnd;
    ChbSendWaitSignal.Checked:= SendWaitSignal;
    ChbStayOpen.Checked:= StayOpen;
    // Receive
    EdtReceiveRemoveLines.Text:= ReceiveRemoveLines;
    ChbReceiveFindStartEnd.Checked:= ReceiveFindStartEnd;
    ChbReceiveWaitSignal.Checked:= ReceiveWaitSignal;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFConfig.ChangeConfig;
begin
  with DisplayedCfgSerial do
  begin
    // General
    ConfigName:= CbxConfigName.Text;
    WorkingDir:= EdtWorkingDir.Text;
    StartCode:= EdtStartCode.Text;
    EndCode:= EdtEndCode.Text;
    SendCode:= EdtSendCode.Text;
    // Com port
    Coding:= CbxCoding.ItemIndex;
    Port:= CbxComPort.Text;
    Speed:= CbxSpeed.Text;
    Parity:= CbxParity.ItemIndex;
    DataBits:= CbxDataBits.Text;
    StopBits:= CbxStopBits.Text;
    FlowControl:= CbxFlowControl.ItemIndex;
    // Send
    StartNullChar:= EdtStartNullChar.Text;
    EndNullChar:= EdtEndNullChar.Text;
    MessageBefore:= ChbMessageBefore.Checked;
    SendRemoveLines:= EdtSendRemoveLines.Text;
    SendFindStartEnd:= ChbSendFindStartEnd.Checked;
    SendWaitSignal:= ChbSendWaitSignal.Checked;
    StayOpen:= ChbStayOpen.Checked;
    // Receive
    ReceiveRemoveLines:= EdtReceiveRemoveLines.Text;
    ReceiveFindStartEnd:= ChbReceiveFindStartEnd.Checked;
    ReceiveWaitSignal:= ChbReceiveWaitSignal.Checked;
  end;
end;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}

function TFConfig.Execute(ACfgSerial: TCfgSerial; Modify: boolean): boolean;
begin
  DisplayedCfgSerial:= ACfgSerial;
  GetAllConfigName(SerialCfgFilename,CbxConfigName.Items);
  InitDisplay;
  CbxConfigName.Enabled:= Modify;
  PopupConfig.AutoPopup:= Modify;
  if ShowModal= mrOk then Result:= true
                     else Result:= false;
  if result then
  begin
    ChangeConfig;
    ACfgSerial:= DisplayedCfgSerial;
  end;
end;

end.

