unit RSChrtbl;

/////////////////////////////////////////////////////////////////////////////
//                     Part of RS232 project                               //
//        Sending and receiving files through RS232 interface              //
//  2003  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Character table form for that project                                   //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA .            }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, ExtCtrls, ComCtrls, ToolWin;

type
  TFCharTable = class(TForm)
    Panel1: TPanel;
    BtnOk: TButton;
    BtnCancel: TButton;
    SbrHint: TStatusBar;
    LblSelection: TLabel;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Dclarations prives }
    CharTableSelection: string;
    procedure InitLanguage;
    procedure ButtonClick(Sender: TObject);
    procedure AddButtons(ToolBar: TToolBar);
  public
    { Dclarations publiques }
    function Execute: byte;
  end;

var
  FCharTable: TFCharTable;

implementation

{$R *.DFM}

uses
  RSlng;

var
  Code: byte;                        // selected character code
  ApplicationOnHint: TNotifyEvent;   // backup application.onhint

{*****************************************************************************}
{ Form function                                                               }
{*****************************************************************************}

procedure TFCharTable.FormCreate(Sender: TObject);
var
  ToolBar: TToolBar;
begin
  InitLanguage;
  ApplicationOnHint:= Application.OnHint;
  Code:= 0;
  ToolBar := TToolBar.Create(Self);
  ToolBar.Parent := Self;
  ToolBar.Align:= alClient;
  ToolBar.AutoSize:= true;
  ToolBar.Flat:= true;
  ToolBar.ButtonWidth:= 23;
  ToolBar.ButtonHeight:= 23;
  AddButtons(ToolBar);
  ToolBar.ShowCaptions := True;
  ToolBar.ShowHint:= true;
end;

{------------------------------------------------------------------------------}

procedure TFCharTable.FormShow(Sender: TObject);
begin
  Application.OnHint:= ShowHint;
  LblSelection.Caption:= CharTableSelection;
end;

{------------------------------------------------------------------------------}

procedure TFCharTable.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  Application.OnHint:= ApplicationOnHint;
end;

{------------------------------------------------------------------------------}

procedure TFCharTable.ShowHint(Sender: TObject);
begin
  SbrHint.SimplePanel:= true;
  SbrHint.SimpleText:= Application.hint;
end;

{*****************************************************************************}
{ Private function                                                            }
{*****************************************************************************}

procedure TFCharTable.InitLanguage;
begin
  Caption:= GetMsg(131);
  BtnOk.Caption:= GetMsg(132);
  BtnOk.Hint:= GetMsg(133);
  BtnCancel.Caption:= GetMsg(134);
  BtnCancel.Hint:= GetMsg(135);
  CharTableSelection:= GetMsg(136);
end;

{------------------------------------------------------------------------------}

procedure TFCharTable.ButtonClick(Sender: TObject);
var
  Title: string;
begin
  with Sender as TToolButton do
  begin
    Code:= Tag;
    Title:= Caption;
    while length(Title) < 5 do Title:= ' ' + Title;
    LblSelection.Caption:= CharTableSelection + '   ' + Title
        + '   (ASCII ' + IntToStr(Code) + ')';
{    if Code = 38 then
      LblSelection.Caption:= CharTableSelection + '   &&   (ASCII '
        + IntToStr(Code) +  ')'
    else
      LblSelection.Caption:= CharTableSelection + '   ' + chr(Code)
        + '   (ASCII ' + IntToStr(Code) + ')';
}
  end;
end;

{------------------------------------------------------------------------------}

procedure TFCharTable.AddButtons(ToolBar: TToolBar);
var
  I: Integer;
begin
  for I := 126 downto 0 do
    begin
      with TToolButton.Create(ToolBar) do
      begin
        Parent := ToolBar;
        case I of
           00: Caption:= 'NUL';
           01: Caption:= 'SOH';
           02: Caption:= 'STX';
           03: Caption:= 'ETX';
           04: Caption:= 'EOT';
           05: Caption:= 'ENQ';
           06: Caption:= 'ACK';
           07: Caption:= 'BEL';
           08: Caption:= 'BS';
           09: Caption:= 'TAB';
           10: Caption:= 'LF';
           11: Caption:= 'VT';
           12: Caption:= 'FF';
           13: Caption:= 'CR';
           14: Caption:= 'SO';
           15: Caption:= 'SI';
           16: Caption:= 'DLE';
           17: Caption:= 'DC1';
           18: Caption:= 'DC2';
           19: Caption:= 'DC3';
           20: Caption:= 'DC4';
           21: Caption:= 'NAK';
           22: Caption:= 'SYN';
           23: Caption:= 'ETB';
           24: Caption:= 'CAN';
           25: Caption:= 'EM';
           26: Caption:= 'SUB';
           27: Caption:= 'ESC';
           28: Caption:= 'FS';
           29: Caption:= 'GS';
           30: Caption:= 'RS';
           31: Caption:= 'US';
           38: Caption:= '&&';
        else Caption := chr(I);
        end;
        Style := tbsButton;
        Hint:= 'ASCII: '+IntToStr(I);
        Tag:= I;
        ShowHint:= false;
        AutoSize:= false;
        if ((I + 1) mod 10)= 0 then Wrap:= true
                               else Wrap:= false;
        OnClick:= ButtonClick;
      end;
    end;
end;

{*****************************************************************************}
{ Public function                                                             }
{*****************************************************************************}

function TFCharTable.Execute: byte;
begin
  Code:= 0;
  if ShowModal= mrOk then Result:= Code
                     else Result:= 0;

end;

{------------------------------------------------------------------------------}

end.
