unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, FileListView, ShellTree, ExtCtrls, ImgList, StdCtrls, FileCtrl,
  ToolWin, Menus;

type
  TFrmExplorer = class(TForm)
    MnuExplorer: TMainMenu;
    Fichier1: TMenuItem;
    ItMnuQuit: TMenuItem;
    Aide1: TMenuItem;
    ItMnuAbout: TMenuItem;
    ItMnuUse: TMenuItem;
    ItMnuFind: TMenuItem;
    ItMnuIndex: TMenuItem;
    TbrExplorer: TToolBar;
    SbrExplorer: TStatusBar;
    DcbDrive: TDriveComboBox;
    TbnSpace1: TToolButton;
    TbnDirectoryUp: TToolButton;
    TbnSpace2: TToolButton;
    TbnCreateDirectory: TToolButton;
    TbnSpace3: TToolButton;
    TbnProperties: TToolButton;
    TbnSpace4: TToolButton;
    TbnLargeIcon: TToolButton;
    TbnSmallIcon: TToolButton;
    TbnList: TToolButton;
    TbnReport: TToolButton;
    TbnSpace5: TToolButton;
    TbnRefresh: TToolButton;
    ImlExplorer: TImageList;
    PnlLeft: TPanel;
    SplExplorer: TSplitter;
    PnlRight: TPanel;
    PnlShellTreeLabel: TPanel;
    PnlFileListLabel: TPanel;
    Affichage1: TMenuItem;
    ItMnuToolBar: TMenuItem;
    ItMnuStatusBar: TMenuItem;
    N3: TMenuItem;
    ItMnuLargeIcon: TMenuItem;
    ItMnuSmallIcon: TMenuItem;
    ItMnuList: TMenuItem;
    ItMnuReport: TMenuItem;
    N6: TMenuItem;
    ItMnuRefresh: TMenuItem;
    ItMnuSumary: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure DcbDriveChange(Sender: TObject);
    procedure TbnDirectoryUpClick(Sender: TObject);
    procedure TbnCreateDirectoryClick(Sender: TObject);
    procedure TbnLargeIconClick(Sender: TObject);
    procedure TbnRefreshClick(Sender: TObject);
    procedure ItMnuQuitClick(Sender: TObject);
    procedure ItMnuToolBarClick(Sender: TObject);
    procedure ItMnuStatusBarClick(Sender: TObject);
    procedure ItMnuLargeIconClick(Sender: TObject);
    procedure ItMnuRefreshClick(Sender: TObject);
    procedure ItMnuIndexClick(Sender: TObject);
    procedure ItMnuFindClick(Sender: TObject);
    procedure ItMnuUseClick(Sender: TObject);
    procedure ItMnuSumaryClick(Sender: TObject);
    procedure ItMnuAboutClick(Sender: TObject);
    procedure TbnPropertiesClick(Sender: TObject);
  private
    { Dclarations prives }
    ShellTree: TShellTree;
    FileList: TFileListView;
    procedure ChangeFileListStyle(Style: byte);
    procedure DisplayCurrentDir(Sender: TObject);
    procedure ShellTreeClick(Sender: TObject);
    procedure ShellTreeKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  public
    { Dclarations publiques }
  end;

var
  FrmExplorer: TFrmExplorer;

implementation

{$R *.DFM}

{*****************************************************************************}
{ FrmExplorer                                                                 }
{*****************************************************************************}

procedure TFrmExplorer.FormCreate(Sender: TObject);
begin
  ShellTree:= TShellTree.Create(self);
  with ShellTree do
  begin
    Parent:= PnlLeft;
    Align:= alClient;
    Path:= '';
    OnClick:= ShellTreeClick;
    OnKeyDown:= ShellTreeKeyDown;
    UpdateTree;
  end;

  FileList:= TFileListView.Create(self);
  with FileList do
  begin
    Parent:= PnlRight;
    Align:= alClient;
    ViewStyle:= vsReport;
    CurrentDir:= 'C:\';
    DeleteEnabled:= true;
    OnDirChange:= DisplayCurrentDir;
  end;
  DcbDrive.Drive:= FileList.CurrentDir[1];
  ShellTree.Path:= FileList.CurrentDir;

  Application.HelpFile:= 'Francais.hlp';
end;

{*****************************************************************************}
{ ShellTree                                                                   }
{*****************************************************************************}

procedure TFrmExplorer.ShellTreeClick(Sender: TObject);
begin
  FileList.CurrentDir:= ShellTree.Path;
end;

procedure TFrmExplorer.ShellTreeKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_F2 : ShellTree.Selected.EditText;
    VK_F5 : ShellTree.UpdateTree;
  end;
end;

{*****************************************************************************}
{ TbrExplorer                                                                 }
{*****************************************************************************}

procedure TFrmExplorer.ChangeFileListStyle(Style: byte);
begin
  case Style of
    1 : begin
          FileList.ViewStyle:= vsIcon;
          TbnLargeIcon.Down:= true;
          ItMnuLargeIcon.Checked:= true;
        end;
    2 : begin
          FileList.ViewStyle:= vsSmallIcon;
          TbnSmallIcon.Down:= true;
          ItMnuSmallIcon.Checked:= true;
        end;
    3 : begin
          FileList.ViewStyle:= vsList;
          TbnList.Down:= true;
          ItMnuList.Checked:= true;
        end;
    4 : begin
          FileList.ViewStyle:= vsReport;
          TbnReport.Down:= true;
          ItMnuReport.Checked:= true;
        end;
  end;
end;

procedure TFrmExplorer.DisplayCurrentDir(Sender: TObject);
begin
  PnlFileListLabel.Caption:= 'Contenu de ' + '''' + FileList.CurrentDir + '''';
end;

procedure TFrmExplorer.DcbDriveChange(Sender: TObject);
begin
  ShellTree.Path:= DcbDrive.Drive + ':\';
  FileList.CurrentDir:= ShellTree.Path;
end;

procedure TFrmExplorer.TbnDirectoryUpClick(Sender: TObject);
begin
  FileList.DoDirUp;
end;

procedure TFrmExplorer.TbnCreateDirectoryClick(Sender: TObject);
begin
  if not FileList.CreateNewDir('') then ;
end;

procedure TFrmExplorer.TbnPropertiesClick(Sender: TObject);
var
  SrcFile: TSearchRec;
  Text: string;
begin
  SrcFile:= FileList.GetFileProperties;
  if SrcFile.Name <> '' then
  begin
    Text:= 'Nom : ' + SrcFile.Name + #13#10;
    if SrcFile.Size <> 0 then
      Text:= Text + 'Taille : ' + IntToStr(SrcFile.Size) + ' octets' + #13#10;
    Text:= Text + 'Date : ' + FormatDateTime('dd/mm/yyyy hh:mm:ss',
      FileDateToDateTime(SrcFile.Time)) + #13#10;
    Text:= Text + #13#10 + 'Attributs :' +#13#10;
    if (SrcFile.Attr and faReadOnly) > 0
      then Text:= Text + '  Lecture seule' + #13#10;
    if (SrcFile.Attr and faHidden) > 0
      then Text:= Text + '  Cach' + #13#10;
    if (SrcFile.Attr and faSysFile) > 0
      then Text:= Text + '  Systme' + #13#10;
    if (SrcFile.Attr and faDirectory) > 0
      then Text:= Text + '  Rpertoire' + #13#10;
    if (SrcFile.Attr and faArchive) > 0
      then Text:= Text + '  Archive' + #13#10;
    MessageDlg(Text, mtInformation, [mbOk], 0);
  end;
end;

procedure TFrmExplorer.TbnLargeIconClick(Sender: TObject);
begin
  with (Sender as TToolButton) do ChangeFileListStyle(Tag);
end;

procedure TFrmExplorer.TbnRefreshClick(Sender: TObject);
begin
  FileList.ReadFileList;
end;

{*****************************************************************************}
{ MnuExplorer                                                                 }
{*****************************************************************************}

procedure TFrmExplorer.ItMnuQuitClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmExplorer.ItMnuToolBarClick(Sender: TObject);
begin
  with ItMnuToolBar do
  begin
    Checked:= not Checked;
    TbrExplorer.Visible:= Checked;
  end;
end;

procedure TFrmExplorer.ItMnuStatusBarClick(Sender: TObject);
begin
  with ItMnuStatusBar do
  begin
    Checked:= not Checked;
    SbrExplorer.Visible:= Checked;
  end;
end;

procedure TFrmExplorer.ItMnuLargeIconClick(Sender: TObject);
begin
  with (Sender as TMenuItem) do ChangeFileListStyle(Tag);
end;

procedure TFrmExplorer.ItMnuRefreshClick(Sender: TObject);
begin
  FileList.ReadFileList;
end;

procedure TFrmExplorer.ItMnuSumaryClick(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-3;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFrmExplorer.ItMnuIndexClick(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-2;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFrmExplorer.ItMnuFindClick(Sender: TObject);
const
  HELP_TAB=15;
  CONTENTS_ACTIVE=-1;
begin
  Application.HelpCommand(HELP_TAB,CONTENTS_ACTIVE);
end;

procedure TFrmExplorer.ItMnuUseClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TFrmExplorer.ItMnuAboutClick(Sender: TObject);
var
  Text: string;
begin
  Text:= 'Demo how to use TFileListView' + #13#10+ #13#10;
  Text:= Text + 'Copyright (C) 2001 Alain JAFFRE';
  MessageDlg(Text, mtInformation, [mbOk], 0);
end;


end.
